/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.For;
import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;

class ImmutableGraph
extends MutableGraph
implements Graph {
    ImmutableGraph() {
    }

    private ImmutableGraph(boolean strict, boolean directed, boolean cluster, Label name, LinkedHashSet<MutableNode> nodes, LinkedHashSet<MutableGraph> subgraphs, List<Link> links, MutableAttributed<MutableGraph, ForNode> nodeAttributes, MutableAttributed<MutableGraph, ForLink> linkAttributes, MutableAttributed<MutableGraph, ForGraph> graphAttributes) {
        super(strict, directed, cluster, name, nodes, subgraphs, links, nodeAttributes, linkAttributes, graphAttributes);
    }

    private ImmutableGraph copyOfMut() {
        return ImmutableGraph.copyOfMut(this);
    }

    static ImmutableGraph copyOfMut(MutableGraph g) {
        return new ImmutableGraph(g.strict, g.directed, g.cluster, g.name, new LinkedHashSet<MutableNode>(g.nodes), new LinkedHashSet<MutableGraph>(g.subgraphs), (List<Link>)new ArrayList<Link>(g.links), g.nodeAttrs, g.linkAttrs, g.graphAttrs);
    }

    @Override
    public MutableGraph toMutable() {
        return this.copy();
    }

    @Override
    public Graph strict() {
        return (ImmutableGraph)this.copyOfMut().setStrict(true);
    }

    @Override
    public Graph directed() {
        return (ImmutableGraph)this.copyOfMut().setDirected(true);
    }

    @Override
    public Graph cluster() {
        return (ImmutableGraph)this.copyOfMut().setCluster(true);
    }

    @Override
    public Graph named(String name) {
        return (ImmutableGraph)this.copyOfMut().setName(name);
    }

    @Override
    public Graph with(LinkSource ... sources) {
        return (ImmutableGraph)this.copyOfMut().add(sources);
    }

    @Override
    public Graph with(List<? extends LinkSource> sources) {
        return (ImmutableGraph)this.copyOfMut().add(sources);
    }

    @Override
    public Graph link(LinkTarget ... targets) {
        return (ImmutableGraph)this.copyOfMut().addLink(targets);
    }

    public Graph link(LinkTarget target) {
        return (ImmutableGraph)this.copyOfMut().addLink(target);
    }

    @Override
    public Attributed<Graph, ForNode> nodeAttr() {
        return new GraphAttributed<ForNode>(MutableGraph::nodeAttrs);
    }

    @Override
    public Attributed<Graph, ForLink> linkAttr() {
        return new GraphAttributed<ForLink>(MutableGraph::linkAttrs);
    }

    @Override
    public Attributed<Graph, ForGraph> graphAttr() {
        return new GraphAttributed<ForGraph>(MutableGraph::graphAttrs);
    }

    @Override
    public List<Link> links() {
        return Collections.unmodifiableList(super.links());
    }

    private class GraphAttributed<F extends For>
    implements Attributed<Graph, F> {
        private final Function<ImmutableGraph, MutableAttributed<MutableGraph, F>> attributeSource;

        public GraphAttributed(Function<ImmutableGraph, MutableAttributed<MutableGraph, F>> attributeSource) {
            this.attributeSource = attributeSource;
        }

        @Override
        public Graph with(Attributes<? extends F> attrs) {
            return (ImmutableGraph)this.attributeSource.apply(ImmutableGraph.this.copyOfMut()).add(attrs);
        }

        @Override
        public Attributes<? super F> applyTo(MapAttributes<? super F> attrs) {
            return this.attributeSource.apply(ImmutableGraph.this).applyTo(attrs);
        }
    }
}

