/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.util.HashMap;
import java.util.Map;

public final class CustomizedSerializerHelper {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final Map<String, Transformer> registry = new HashMap<String, Transformer>();

    public static synchronized void register(String name, Transformer transfromer) {
        try {
            if (registry.put(name, transfromer) != null) {
                LOGGER.error("[CustomizedSerializer] {0} is registered multiple times", name);
            }
        }
        catch (Exception e) {
            LOGGER.error("", "[CustomizedSerializer] registers error:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String catMethodName(String serviceName, String methodName, String[] sig) {
        StringBuilder methodKeyBuilder = new StringBuilder(serviceName);
        methodKeyBuilder.append(methodName);
        for (int i = 0; i < sig.length; ++i) {
            methodKeyBuilder.append(sig[i]);
        }
        return methodKeyBuilder.toString();
    }

    public static Transformer getTransformer(String name) {
        return registry.get(name);
    }

    public static interface Transformer {
        public byte[][] encodeParameters(Object[] var1) throws Exception;

        public Object[] decodeParameters(byte[][] var1) throws Exception;

        public byte[] encodeResult(Object var1) throws Exception;

        public Object decodeResult(byte[] var1) throws Exception;
    }
}

