/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.logger;

import com.taobao.hsf.LifeCycle;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.concurrent.atomic.AtomicBoolean;

public class LoggerInit
implements LifeCycle {
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"taobao.hsf");
    public static final Logger LOGGER_ADDRESS = LoggerFactory.getLogger((String)"taobao.hsf.address");
    public static final Logger LOGGER_CONFIG = LoggerFactory.getLogger((String)"taobao.hsf.config");
    public static final Logger LOGGER_REMOTING = LoggerFactory.getLogger((String)"taobao.hsf.remoting");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initHSFLog() throws Exception {
        if (inited.compareAndSet(false, true)) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(LoggerInit.class.getClassLoader());
                LOGGER.setLevel(Level.INFO);
                LOGGER.activateAppender("hsf", "hsf.log", "GBK");
                LOGGER.setAdditivity(false);
                LOGGER_ADDRESS.setLevel(Level.INFO);
                LOGGER_ADDRESS.activateAppender("hsf", "hsf-address.log", "GBK");
                LOGGER_ADDRESS.setAdditivity(false);
                LOGGER_CONFIG.setLevel(Level.INFO);
                LOGGER_CONFIG.activateAppenderWithTimeAndSizeRolling("hsf", "hsf-config.log", "GBK", "5MB", "yyyy-MM");
                LOGGER_CONFIG.setAdditivity(false);
                LOGGER_REMOTING.setLevel(Level.INFO);
                LOGGER_REMOTING.activateAsyncAppender("hsf", "hsf-remoting.log", "GBK");
                LOGGER_REMOTING.setAdditivity(false);
                System.setProperty("HSF.LOG.PATH", LoggerHelper.getLogpath() + "hsf");
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public static String changeLogLevel(int level) throws Exception {
        switch (level) {
            case 0: {
                LOGGER.setLevel(Level.DEBUG);
                LOGGER_ADDRESS.setLevel(Level.DEBUG);
                LOGGER_REMOTING.setLevel(Level.DEBUG);
                return Level.DEBUG.toString();
            }
            case 2: {
                LOGGER.setLevel(Level.WARN);
                LOGGER_ADDRESS.setLevel(Level.WARN);
                LOGGER_REMOTING.setLevel(Level.WARN);
                return Level.WARN.toString();
            }
            case 3: {
                LOGGER.setLevel(Level.ERROR);
                LOGGER_ADDRESS.setLevel(Level.ERROR);
                LOGGER_REMOTING.setLevel(Level.ERROR);
                return Level.ERROR.toString();
            }
            case 4: {
                LOGGER.setLevel(Level.OFF);
                LOGGER_ADDRESS.setLevel(Level.OFF);
                LOGGER_REMOTING.setLevel(Level.OFF);
                return Level.OFF.toString();
            }
        }
        LOGGER.setLevel(Level.INFO);
        LOGGER_ADDRESS.setLevel(Level.INFO);
        LOGGER_REMOTING.setLevel(Level.INFO);
        return Level.INFO.toString();
    }

    public static void changeLogLevel(String levelString) {
        try {
            levelString = LoggerInit.changeFatalToOff(levelString);
            Level level = Level.codeOf((String)levelString.toUpperCase());
            LOGGER.setLevel(Level.WARN);
            LOGGER.warn("\u6539\u53d8\u65e5\u5fd7\u7ea7\u522b\u4e3a" + level.toString());
            LOGGER.setLevel(level);
            LOGGER_ADDRESS.setLevel(level);
            LOGGER_REMOTING.setLevel(level);
        }
        catch (Throwable t) {
            LOGGER.error("", "\u6539\u53d8\u65e5\u5fd7\u7ea7\u522b\u5931\u8d25", t);
        }
    }

    private static String changeFatalToOff(String levelString) {
        if ("FATAL".equalsIgnoreCase(levelString)) {
            return "OFF";
        }
        return levelString;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

