/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.util.ServiceIndexUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class ConsumerMethodModel {
    private static final String TIMEOUT_TYPE_KEY = "_TIMEOUT";
    private static final String SYNC_INVOKE = "SYNC";
    private final Method method;
    private final String enterMsg;
    private final ServiceMetadata metadata;
    private final boolean isCallBack;
    private final boolean isFuture;
    private final String[] parameterTypes;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final String methodNameToLog;
    private final String methodName;
    private final int executeTimes;
    private final boolean isGeneric;
    private final String invokeType;
    private final boolean isReliable;
    private final int timeout;

    public ConsumerMethodModel(Method method, ServiceMetadata metadata) {
        this.method = method;
        this.parameterClasses = method.getParameterTypes();
        this.returnClass = method.getReturnType();
        this.parameterTypes = this.createParamSignature(this.parameterClasses);
        this.methodName = method.getName();
        this.metadata = metadata;
        this.isGeneric = this.isGeneric();
        this.enterMsg = "invoke service:" + this.getUniqueName() + this.methodName + Arrays.toString(this.parameterTypes);
        this.isCallBack = metadata.isCallBackMethod(this.methodName);
        this.isFuture = metadata.isFutureMethod(this.methodName);
        this.methodNameToLog = this.isGeneric ? ServiceIndexUtil.getMethodNameToLog(this.parameterTypes[0], Arrays.copyOfRange(this.parameterTypes, 1, this.parameterTypes.length)) : ServiceIndexUtil.getMethodNameToLog(this.methodName, this.parameterTypes);
        this.executeTimes = metadata.getRetries(this.methodName) + 1;
        this.isReliable = metadata.isReliableMethod(this.methodName);
        this.timeout = this.createTimeout();
        this.invokeType = this.judgeInvokeType(metadata);
    }

    private String judgeInvokeType(ServiceMetadata metadata) {
        if (this.isCallBack) {
            return "CALLBACK";
        }
        if (this.isFuture) {
            return "FUTURE";
        }
        if (this.isReliable) {
            return "RELIABLE";
        }
        return SYNC_INVOKE;
    }

    public ConsumerMethodModel(String methodName, String[] parameterTypes, ServiceMetadata metadata) {
        this.method = null;
        this.parameterClasses = null;
        this.returnClass = Map.class;
        this.metadata = metadata;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.enterMsg = "invoke service:" + this.getUniqueName() + this.methodName + Arrays.toString(this.parameterTypes);
        this.isCallBack = metadata.isCallBackMethod(this.methodName);
        this.isFuture = metadata.isFutureMethod(this.methodName);
        this.isGeneric = false;
        this.methodNameToLog = ServiceIndexUtil.getMethodNameToLog(methodName, parameterTypes);
        this.executeTimes = metadata.getRetries(methodName) + 1;
        this.isReliable = metadata.isReliableMethod(this.methodName);
        this.timeout = this.createTimeout();
        this.invokeType = this.judgeInvokeType(metadata);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getMethodNameToLog() {
        return this.methodNameToLog;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public String getInvokeType() {
        return this.invokeType;
    }

    public boolean isReliable() {
        return this.isReliable;
    }

    public String getUniqueName() {
        return this.metadata.getUniqueName();
    }

    public String getEnterMsg() {
        return this.enterMsg;
    }

    public boolean isCallBackMethod() {
        return this.isCallBack;
    }

    public boolean isFutureMethod() {
        return this.isFuture;
    }

    public boolean isAsyncMethod() {
        return this.isCallBack || this.isFuture;
    }

    public String getMethodName(HSFRequest request) {
        if (this.isGeneric) {
            return request.getMethodArgs()[0].toString();
        }
        return this.methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    private String[] createParamSignature(Class<?>[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getName();
        }
        return paramSig;
    }

    private int createTimeout() {
        if (this.isReliable) {
            return 1000;
        }
        MethodSpecial special = this.metadata.getMethodSpecial(this.methodName);
        if (special == null && this.isGeneric) {
            special = this.metadata.getMethodSpecial("$invoke");
        }
        if (null != special) {
            return (int)special.getClientTimeout();
        }
        special = this.metadata.getMethodSpecial("*");
        if (null != special) {
            return (int)special.getClientTimeout();
        }
        if (this.metadata.getProperty(TIMEOUT_TYPE_KEY) != null) {
            return Integer.parseInt(this.metadata.getProperty(TIMEOUT_TYPE_KEY));
        }
        return 0;
    }

    private boolean isGeneric() {
        return this.methodName.equals("$invoke") && this.parameterTypes != null && this.parameterTypes.length == 3;
    }

    public String getSecureKey() {
        return this.metadata.getSecureKey();
    }

    public int getExecuteTimes() {
        return this.executeTimes;
    }

    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }
}

