/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.notify.client.NotifyManagerBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ConsumerServiceModel {
    private final ServiceMetadata metadata;
    private final Object proxyObject;
    private final Map<Method, ConsumerMethodModel> methodModels = new IdentityHashMap<Method, ConsumerMethodModel>();
    private volatile NotifyManagerBean notifyManager;

    public ConsumerServiceModel(ServiceMetadata metadata, Object proxyObject, boolean isJava) {
        this.metadata = metadata;
        this.proxyObject = proxyObject;
        if (proxyObject != null) {
            Class<?> proxyClass = proxyObject.getClass();
            try {
                if (isJava) {
                    for (Field field : proxyClass.getDeclaredFields()) {
                        field.setAccessible(true);
                        Method method = (Method)field.get(this.proxyObject);
                        this.methodModels.put(method, new ConsumerMethodModel(method, metadata));
                    }
                } else {
                    Field field = proxyClass.getDeclaredField("methods");
                    field.setAccessible(true);
                    for (Method method : (Method[])field.get(this.proxyObject)) {
                        this.methodModels.put(method, new ConsumerMethodModel(method, metadata));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public NotifyManagerBean getNotifyManager() {
        return this.notifyManager;
    }

    public void setNotifyManager(NotifyManagerBean notifyManager) {
        this.notifyManager = notifyManager;
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }
}

