/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.taobao.jaket.JaketTypeBuilder;
import com.taobao.jaket.model.TypeDefinition;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class ProviderMethodModel {
    private static final AtomicInteger INDEX_GENERATOR = new AtomicInteger(1);
    private static final JaketTypeBuilder builder = new JaketTypeBuilder();
    private final transient Method method;
    private final String methodName;
    private final String[] methodArgTypes;
    private final transient String methodKey;
    private final transient String methodLogname;
    private final String serviceName;
    private final transient int index = INDEX_GENERATOR.getAndIncrement();
    private final transient int timeout;
    private volatile int responseTime;
    private final AtomicInteger elapseTime = new AtomicInteger();
    private final AtomicInteger invokeCount = new AtomicInteger();
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final String spasMethodName;

    public ProviderMethodModel(Method method, String serviceName, int timeout) {
        this.method = method;
        this.serviceName = serviceName;
        this.methodName = method.getName();
        StringBuilder methodkeyBuilder = new StringBuilder(method.getName());
        StringBuilder logMethodBuilder = new StringBuilder(method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            this.methodArgTypes = new String[parameterTypes.length];
            logMethodBuilder.append("~");
            int index = 0;
            for (Class<?> paramType : parameterTypes) {
                this.methodArgTypes[index++] = paramType.getName();
                methodkeyBuilder.append(paramType.getName());
                int charIndex = paramType.getName().lastIndexOf(46) + 1;
                logMethodBuilder.append(paramType.getName().charAt(charIndex));
            }
        } else {
            this.methodArgTypes = new String[0];
        }
        this.methodLogname = logMethodBuilder.toString();
        this.methodKey = methodkeyBuilder.toString();
        this.timeout = timeout;
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] genericParamTypes = method.getGenericParameterTypes();
        Object[] pms = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            try {
                TypeDefinition td = builder.build(genericParamTypes[i], paramTypes[i]);
                pms[i] = td.getType();
                continue;
            }
            catch (Throwable e) {
                pms[i] = paramTypes[i].getName();
            }
        }
        this.spasMethodName = (this.methodName + "#" + StringUtils.join((Object[])pms, (char)'#')).replace(',', '#');
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodLogname() {
        return this.methodLogname;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodKeyWithServiceName() {
        return this.serviceName + "#" + this.methodKey;
    }

    public String[] getMethodArgTypes() {
        return this.methodArgTypes;
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getIndex() {
        return this.index;
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(int responseTime) {
        this.responseTime = responseTime;
    }

    public AtomicInteger getThreadCount() {
        return this.threadCount;
    }

    public String getSpasMethodName() {
        return this.spasMethodName;
    }

    public AtomicInteger getElapseTime() {
        return this.elapseTime;
    }

    public AtomicInteger getInvokeCount() {
        return this.invokeCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.methodArgTypes);
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderMethodModel other = (ProviderMethodModel)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.methodArgTypes, other.methodArgTypes);
    }
}

