/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model.metadata;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.RemoteCallType;
import com.taobao.hsf.event.Event;
import com.taobao.hsf.event.EventDispatcher;
import com.taobao.hsf.event.EventType;
import com.taobao.hsf.model.metadata.MethodSpecial;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ServiceMetadata
implements Serializable {
    private static final long serialVersionUID = 11L;
    public static final String DEFAULT_VERSION = "1.0.0";
    public static final String DEFAULT_GROUP = "HSF";
    public static final String METHOD_TO_INJECT_CONSUMERIP_PROP_KEY = "METHOD_TO_INJECT_CONSUMERIP_PROP_KEY";
    public static final String METADATA_DELAYED_PUBLISH = "METADATA_DELAYED_PUBLISH";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_TRUE = "true";
    public final Object syncLock = new Object();
    private final AtomicBoolean needNotify = new AtomicBoolean(false);
    private final boolean isProvider;
    private final boolean isTOP;
    private final boolean isNDI;
    private String interfaceName = "";
    private Class<?> ifClazz = null;
    private String version = "1.0.0";
    private String dubboVersion = "1.0.0";
    private String defaultGroup = "HSF";
    private volatile String group = "HSF";
    private volatile boolean isGroupChanged = false;
    private AtomicBoolean readyToPublish = new AtomicBoolean(true);
    private String name;
    private String desc;
    private String isSupportAsyncall = "false";
    private volatile int maxWaitTimeForCsAddress = -1;
    private transient CountDownLatch csAddressCountDownLatch = new CountDownLatch(1);
    public static final String WRITE_MODE_UNIT = "unit";
    public static final String WRITE_MODE_CENTER = "center";
    private String writeMode;
    private int route = -1;
    private boolean routeCheck = true;
    private boolean enableTXC = false;
    private String generic;
    private String filter;
    private int retries = 0;
    private String proxyStyle = "jdk";
    private EnumConfigStyle configStyle = EnumConfigStyle.HSF;
    private int connectionNum = 1;
    private final transient AtomicLong connectionIndex = new AtomicLong(0L);
    private int timeout = 3000;
    private Object callbackHandler;
    private Object callbackInvoker;
    private ThreadLocal<Serializable> invokeContext = new ThreadLocal();
    private String callbackMethodSuffix = "_callback";
    private final Map<String, AsyncallMethod> asyncallMethods = new HashMap<String, AsyncallMethod>();
    private final Map<String, MethodSpecial> methodSpecialMap = new HashMap<String, MethodSpecial>();
    private final Map<String, String> serviceProps = new HashMap<String, String>();
    private int consumerMaxPoolSize = 0;
    private AtomicInteger curConsumerMaxPoolSize = null;
    private int corePoolSize = 0;
    private int maxPoolSize = 0;
    private transient Object target;
    private volatile transient ClassLoader servicePojoClassLoader;
    private volatile transient String uniqueServiceName;
    private volatile transient String uniqueDubboServiceName;
    private boolean isSupportEcho = false;
    private String secureKey;
    private List<String> configserverCenter;
    private boolean broadcast = false;
    private String methodAttachInvoke;
    private String consistent = Boolean.FALSE.toString();

    public ServiceMetadata(boolean isProvider, boolean isTop, boolean isNDI) {
        this.isProvider = isProvider;
        this.isTOP = isTop;
        this.isNDI = isNDI;
    }

    public ServiceMetadata(boolean isProvider, boolean isTop) {
        this(isProvider, isTop, false);
    }

    public ServiceMetadata(boolean isProvider) {
        this(isProvider, false);
    }

    public ServiceMetadata() {
        this(false, false);
    }

    public boolean isEnableTXC() {
        return this.enableTXC;
    }

    public void setEnableTXC(boolean enableTXC) {
        this.enableTXC = enableTXC;
    }

    public String getMethodAttachInvoke() {
        return this.methodAttachInvoke;
    }

    public ThreadLocal<Serializable> getInvokeContext() {
        return this.invokeContext;
    }

    public void addAsyncallMethod(AsyncallMethod asyncFuncDesc) {
        this.asyncallMethods.put(asyncFuncDesc.getName(), asyncFuncDesc);
    }

    public boolean isProvider() {
        return this.isProvider;
    }

    public void addProperty(String propName, String propValue) {
        if ("_TIMEOUT".equalsIgnoreCase(propName)) {
            this.timeout = Integer.valueOf(propValue);
        }
        this.serviceProps.put(propName, propValue);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void removeProperty(String propName) {
        this.serviceProps.remove(propName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configStyle == null ? 0 : this.configStyle.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceMetadata other = (ServiceMetadata)obj;
        if (this.configStyle != other.configStyle) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public boolean isTOP() {
        return this.isTOP;
    }

    public boolean isNDI() {
        return this.isNDI;
    }

    public AsyncallMethod getAsyncallMethod(String method) {
        if (this.asyncallMethods.isEmpty()) {
            return null;
        }
        return this.asyncallMethods.get(method.toLowerCase());
    }

    public Object getCallbackHandler() {
        return this.callbackHandler;
    }

    public String getCallbackMethodSuffix() {
        return this.callbackMethodSuffix;
    }

    public String getProxyStyle() {
        return this.proxyStyle;
    }

    public void setProxyStyle(String proxyStyle) {
        this.proxyStyle = proxyStyle;
    }

    public int getConnectionIndex() {
        if (this.connectionNum == 1) {
            return 0;
        }
        return (int)(this.connectionIndex.getAndIncrement() % (long)this.connectionNum);
    }

    public boolean isReadyToPublish() {
        return this.readyToPublish.get();
    }

    public boolean setReadyToPublish(boolean readyToPublish) {
        return this.readyToPublish.compareAndSet(!readyToPublish, readyToPublish);
    }

    public int getConsumerMaxPoolSize() {
        return this.consumerMaxPoolSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public AtomicInteger getCurConsumerMaxPoolSize() {
        return this.curConsumerMaxPoolSize;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getGroup() {
        if (null == this.group || "".equals(this.group)) {
            return DEFAULT_GROUP;
        }
        return this.group;
    }

    public Class<?> getIfClazz() {
        return this.ifClazz;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public MethodSpecial getMethodSpecial(String methodName) {
        if (this.methodSpecialMap.isEmpty()) {
            return null;
        }
        return this.methodSpecialMap.get(methodName);
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String propName) {
        return this.serviceProps.get(propName);
    }

    public Map<String, String> getServiceProperties() {
        return this.serviceProps;
    }

    public Object getTarget() {
        return this.target;
    }

    public void initUniqueName() {
        this.uniqueServiceName = this.interfaceName + ":" + this.version;
        this.initDubboUniqueName();
    }

    public void initDubboUniqueName() {
        this.uniqueDubboServiceName = this.interfaceName + ":" + this.dubboVersion;
    }

    public String getUniqueName() {
        return this.uniqueServiceName;
    }

    public String getUniqueDubboName() {
        return this.uniqueDubboServiceName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDubboVersion() {
        return this.dubboVersion;
    }

    public boolean isAsyncall(String method) {
        return !this.asyncallMethods.isEmpty() && this.asyncallMethods.containsKey(method.toLowerCase());
    }

    public boolean isDelayedPublish() {
        return VALUE_TRUE.equals(this.getProperty(METADATA_DELAYED_PUBLISH));
    }

    public boolean isSupportAsyn() {
        return VALUE_TRUE.equals(this.isSupportAsyncall);
    }

    public void setCallbackHandler(Object callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setCallbackMethodSuffix(String callbackMethodSuffix) {
        this.callbackMethodSuffix = callbackMethodSuffix;
    }

    public void setConsumerMaxPoolSize(int consumerMaxPoolSize) {
        this.setCurConsumerMaxPoolSize(consumerMaxPoolSize);
        this.consumerMaxPoolSize = consumerMaxPoolSize;
    }

    public void setCorePoolSize(String corePoolSize) {
        if (corePoolSize != null) {
            try {
                this.corePoolSize = Integer.parseInt(corePoolSize.trim());
            }
            catch (NumberFormatException e) {
                this.illArgsException("Property corePoolSize must be an integer!");
            }
        }
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public void setIfClazz(Class<?> ifClazz) {
        this.ifClazz = ifClazz;
        this.servicePojoClassLoader = ifClazz.getClassLoader();
    }

    public void setInterfaceName(String _interfaceName) {
        this.interfaceName = _interfaceName;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        if (maxPoolSize != null) {
            try {
                this.maxPoolSize = Integer.parseInt(maxPoolSize.trim());
            }
            catch (NumberFormatException e) {
                this.illArgsException("Property maxPoolSize must be an integer!");
            }
        }
    }

    public ClassLoader getServicePojoClassLoader() {
        return this.servicePojoClassLoader;
    }

    public void setMethodSpecials(MethodSpecial[] methodSpecials) {
        for (int i = 0; i < methodSpecials.length; ++i) {
            this.methodSpecialMap.put(methodSpecials[i].getMethodName(), methodSpecials[i]);
        }
    }

    public Collection<MethodSpecial> getMethodSpecials() {
        return this.methodSpecialMap.values();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSupportAsyncall(String asyncall) {
        this.isSupportAsyncall = asyncall;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setVersion(String _version) {
        this.version = _version;
        this.checkVersion();
    }

    public void setDubboVersion(String _version) {
        this.dubboVersion = _version;
    }

    public Object getCallbackInvoker() {
        return this.callbackInvoker;
    }

    public EnumConfigStyle getConfigStyle() {
        return this.configStyle;
    }

    public void setCallbackInvoker(Object callbackInvoker) {
        this.callbackInvoker = callbackInvoker;
    }

    public void setConfigStyle(String configStyle) {
        if (configStyle == null || configStyle.isEmpty()) {
            return;
        }
        this.configStyle = EnumConfigStyle.valueOf(configStyle.toUpperCase());
    }

    public String toAsyncallMethodString() {
        StringBuilder amethodString = new StringBuilder();
        for (AsyncallMethod amethod : this.asyncallMethods.values()) {
            amethodString.append(amethod.toString());
            amethodString.append("&");
        }
        return amethodString.toString();
    }

    public String toString() {
        return this.getUniqueName();
    }

    private void checkVersion() {
        if (this.version == null || "".equals(this.version.trim()) || "null".equalsIgnoreCase(this.version)) {
            this.illArgsException("ServiceMetadata.version=" + this.version);
        }
    }

    private void illArgsException(String msg) {
        throw new IllegalArgumentException(msg);
    }

    private void setCurConsumerMaxPoolSize(int poolsize) {
        if (this.curConsumerMaxPoolSize != null) {
            int currentConsumerCount = this.consumerMaxPoolSize - this.curConsumerMaxPoolSize.get();
            this.curConsumerMaxPoolSize.set(poolsize - currentConsumerCount);
        } else {
            this.curConsumerMaxPoolSize = new AtomicInteger(poolsize);
        }
    }

    public int getConnectionNum() {
        return this.connectionNum;
    }

    public void setConnectionNum(int connectionNum) {
        this.connectionNum = connectionNum;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        this.generic = generic;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSupportEcho(boolean value) {
        this.isSupportEcho = value;
    }

    public boolean isSupportEcho() {
        return this.isSupportEcho;
    }

    public void setRetries(int retries) {
        if (retries >= 0) {
            this.retries = retries;
        }
    }

    public int getRetries(String methodName) {
        MethodSpecial methodSpecial = this.getMethodSpecial(methodName);
        if (methodSpecial != null) {
            return methodSpecial.getRetries();
        }
        return this.retries;
    }

    public AtomicBoolean getNeedNotify() {
        return this.needNotify;
    }

    public String getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(String writeMode) {
        this.writeMode = writeMode;
    }

    public int getRoute() {
        return this.route;
    }

    public void setRoute(int route) {
        this.route = route;
    }

    public boolean getRouteCheck() {
        return this.routeCheck;
    }

    public void setRouteCheck(boolean routeCheck) {
        this.routeCheck = routeCheck;
    }

    public void fireMetadataAfterChanged() {
        EventDispatcher.fireEvent(new Event(EventType.MetaDataChanged, this));
    }

    public void fireMetadataBeforeChanged() {
        EventDispatcher.fireEvent(new Event(EventType.MetaDataBeforeChanged, this));
    }

    public String getSecureKey() {
        return this.secureKey;
    }

    public void setSecureKey(String secureKey) {
        this.secureKey = secureKey;
    }

    public List<String> getConfigserverCenter() {
        return this.configserverCenter;
    }

    public void setConfigserverCenter(List<String> configserverCenter) {
        this.configserverCenter = configserverCenter;
    }

    public void setMaxWaitTimeForCsAddress(int timeout) {
        this.maxWaitTimeForCsAddress = timeout;
    }

    public int getMaxWaitTimeForCsAddress() {
        return this.maxWaitTimeForCsAddress;
    }

    public CountDownLatch getCsAddressCountDownLatch() {
        return this.csAddressCountDownLatch;
    }

    public boolean isCallBackMethod(String methodName) {
        if (this.asyncallMethods.isEmpty()) {
            return false;
        }
        AsyncallMethod aMethod = this.getAsyncallMethod(methodName);
        return aMethod == null ? false : "CALLBACK".equals(aMethod.getType());
    }

    public boolean isFutureMethod(String methodName) {
        if (this.asyncallMethods.isEmpty()) {
            return false;
        }
        AsyncallMethod aMethod = this.getAsyncallMethod(methodName);
        return aMethod == null ? false : "FUTURE".equals(aMethod.getType());
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isReliableMethod(String methodName) {
        if (this.asyncallMethods.isEmpty()) {
            return false;
        }
        AsyncallMethod aMethod = this.getAsyncallMethod(methodName);
        return aMethod == null ? false : "RELIABLE".equals(aMethod.getType());
    }

    public boolean isExistReliableCall() {
        for (AsyncallMethod amethod : this.asyncallMethods.values()) {
            if (!amethod.isReliable()) continue;
            return true;
        }
        return false;
    }

    public boolean isReliableCallback() {
        for (AsyncallMethod amethod : this.asyncallMethods.values()) {
            if (!amethod.isReliableCallback()) continue;
            return true;
        }
        return false;
    }

    public String getConsistent() {
        return this.consistent;
    }

    public void setConsistent(String consistent) {
        this.consistent = consistent;
    }

    public void changeGroup(String newGroup) {
        this.setGroup(newGroup);
        this.isGroupChanged = true;
    }

    public void recoverGroupFlag() {
        this.isGroupChanged = false;
    }

    public boolean isGroupChanged() {
        return this.isGroupChanged;
    }

    public void setMethodAttachInvokeContext(String methodName) {
        this.methodAttachInvoke = methodName;
    }

    public void setInvokeContext(ThreadLocal<Serializable> invokeContext) {
        this.invokeContext = invokeContext;
    }

    public class AsyncallMethod
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private Method method;
        private Class<?> returnType;
        private String type;
        private String callback;
        private Object callbackInstance;
        private boolean isReliableCallback;

        public String getCallback() {
            return this.callback;
        }

        public Object getCallbackInstance() {
            return this.callbackInstance;
        }

        public boolean isReliableCallback() {
            return this.isReliableCallback;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getName() {
            return this.name;
        }

        public void setReliableCallback(boolean isReliableCallback) {
            this.isReliableCallback = isReliableCallback;
        }

        public boolean isReliable() {
            return "reliable".equalsIgnoreCase(this.type);
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String getType() {
            return this.type.toUpperCase();
        }

        public boolean isCallback() {
            return RemoteCallType.CALLBACK.getCallType().equalsIgnoreCase(this.type);
        }

        public boolean isFuture() {
            return RemoteCallType.FUTURE.getCallType().equalsIgnoreCase(this.type);
        }

        public void setCallback(String callback) {
            this.callback = callback;
        }

        public void setCallbackInstance(Object _callbackInstance) {
            this.callbackInstance = _callbackInstance;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public void setName(String name) {
            this.name = name.toLowerCase();
        }

        public void setReturnType(Class<?> returnType) {
            this.returnType = returnType;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder("name:");
            strBuilder.append(this.name);
            strBuilder.append(";type:");
            strBuilder.append(this.type);
            strBuilder.append(";listener:");
            strBuilder.append(this.callback);
            return strBuilder.toString();
        }
    }
}

