/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;

public class AppInfoUtils {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    public static final String PARAM_MARKING_PROJECT = "project.name";
    private static final String PARAM_MARKING_JBOSS = "jboss.server.home.dir";
    private static final String PARAM_MARKING_JETTY = "jetty.home";
    private static final String PARAM_MARKING_TOMCAT = "catalina.base";
    private static final String LINUX_ADMIN_HOME = "/home/admin/";
    private static final String SERVER_JBOSS = "jboss";
    private static final String SERVER_JETTY = "jetty";
    private static final String SERVER_TOMCAT = "tomcat";
    private static final String SERVER_UNKNOWN = "unknown server";
    private static String appName = null;
    private static String serverType = null;
    public static final AtomicBoolean appRunning = new AtomicBoolean(false);
    public static int hsfSpringBeanCountDown = 0;
    public static int dubboSpringBeanCountDown = 0;

    public static String getAppName() {
        return appName;
    }

    public static void initAppName(ServiceMetadata metadata) {
        if (appName != null) {
            return;
        }
        appName = System.getProperty(PARAM_MARKING_PROJECT);
        if (appName != null) {
            return;
        }
        String serverHome = null;
        if (SERVER_JBOSS.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JBOSS);
        } else if (SERVER_JETTY.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JETTY);
        } else if (SERVER_TOMCAT.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_TOMCAT);
        }
        if (serverHome != null && serverHome.startsWith(LINUX_ADMIN_HOME)) {
            appName = StringUtils.substringBetween((String)serverHome, (String)LINUX_ADMIN_HOME, (String)File.separator);
        }
        if (appName != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(metadata.getInterfaceName());
            String path = clazz.getResource("/").getPath();
            File f = new File(path);
            if (f.exists()) {
                String fileName = f.getName();
                int index = fileName.lastIndexOf(".");
                if (index > 0) {
                    fileName = fileName.substring(0, index);
                }
                appName = fileName;
            } else {
                LOGGER.error("", "[AppInfoUtils] Get application name failed, file not found: " + f);
            }
        }
        catch (Throwable t) {
            LOGGER.error("", "[AppInfoUtils] Get application name failed: " + t.getMessage());
        }
        if (appName == null) {
            appName = "unknown";
        }
    }

    public static String getHSFLogPath() {
        return System.getProperty("HSF.LOG.PATH");
    }

    public static String getServerType() {
        if (serverType != null) {
            return serverType;
        }
        serverType = System.getProperty(PARAM_MARKING_JBOSS) != null ? SERVER_JBOSS : (System.getProperty(PARAM_MARKING_JETTY) != null ? SERVER_JETTY : (System.getProperty(PARAM_MARKING_TOMCAT) != null ? SERVER_TOMCAT : SERVER_UNKNOWN));
        return serverType;
    }
}

