/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ClassUtils {
    private static final ClassLoader classLoader = ClassUtils.class.getClassLoader();
    private static final ConcurrentMap<String, Class<?>> classCache = new ConcurrentHashMap();

    private static void registerCommonClasses(Map<String, Class<?>> commonClassCache, Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = (Class<?>)classCache.get(name);
        if (clazz == null) {
            clazz = Class.forName(name, false, classLoader);
            classCache.putIfAbsent(name, clazz);
        }
        return clazz;
    }

    static {
        HashMap<Class, Class<Comparable<Boolean>>> primitiveWrapperTypeMap = new HashMap<Class, Class<Comparable<Boolean>>>(8);
        HashMap primitiveTypeToWrapperMap = new HashMap(8);
        HashMap<String, Class> primitiveTypeNameMap = new HashMap<String, Class>(32);
        HashMap commonClassCache = new HashMap(32);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Map.Entry entry : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
            ClassUtils.registerCommonClasses(commonClassCache, (Class)entry.getKey());
        }
        HashSet<Object> primitiveTypes = new HashSet<Object>(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        primitiveTypes.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(commonClassCache, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(commonClassCache, Number.class, Number[].class, String.class, String[].class, Object.class, Object[].class, Class.class, Class[].class);
        ClassUtils.registerCommonClasses(commonClassCache, Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        classCache.putAll(commonClassCache);
        classCache.putAll(primitiveTypeNameMap);
    }
}

