/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JVMUtils {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;
    private static volatile MemoryMXBean memoryMBean;
    private static Object lock;

    public static void jMap(String fileName, boolean live) throws Exception {
        JVMUtils.initHotspotMBean();
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
        hotspotMBean.dumpHeap(fileName, live);
    }

    public static void jstack(OutputStream stream) throws Exception {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] elements = entry.getValue();
            if (elements == null || elements.length <= 0) continue;
            String threadName = entry.getKey().getName();
            stream.write(("Thread Name :[" + threadName + "]\n").getBytes());
            for (StackTraceElement el : elements) {
                String stack = el.toString() + "\n";
                stream.write(stack.getBytes());
            }
            stream.write("\n".getBytes());
        }
    }

    public static double memoryUsed(OutputStream stream) throws Exception {
        JVMUtils.initMemoryMBean();
        stream.write("**********************************Memory Used**********************************\n".getBytes());
        String heapMemoryUsed = memoryMBean.getHeapMemoryUsage().toString() + "\n";
        stream.write(("Heap Memory Used: " + heapMemoryUsed).getBytes());
        String nonHeapMemoryUsed = memoryMBean.getNonHeapMemoryUsage().toString() + "\n";
        stream.write(("NonHeap Memory Used: " + nonHeapMemoryUsed).getBytes());
        return (double)memoryMBean.getHeapMemoryUsage().getUsed() / (double)memoryMBean.getHeapMemoryUsage().getMax();
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<HotSpotDiagnosticMXBean>(){

            @Override
            public HotSpotDiagnosticMXBean run() throws Exception {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> s = server.queryNames(new ObjectName(JVMUtils.HOTSPOT_BEAN_NAME), null);
                Iterator<ObjectName> itr = s.iterator();
                if (itr.hasNext()) {
                    ObjectName name = itr.next();
                    HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), HotSpotDiagnosticMXBean.class);
                    return bean;
                }
                return null;
            }
        });
    }

    private static MemoryMXBean getMemoryMBean() throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<MemoryMXBean>(){

            @Override
            public MemoryMXBean run() throws Exception {
                return ManagementFactory.getMemoryMXBean();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initHotspotMBean() throws Exception {
        if (hotspotMBean == null) {
            Object object = lock;
            synchronized (object) {
                if (hotspotMBean == null) {
                    hotspotMBean = JVMUtils.getHotspotMBean();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMemoryMBean() throws Exception {
        if (memoryMBean == null) {
            Object object = lock;
            synchronized (object) {
                if (memoryMBean == null) {
                    memoryMBean = JVMUtils.getMemoryMBean();
                }
            }
        }
    }

    static {
        lock = new Object();
    }
}

