/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import java.util.HashMap;
import java.util.Map;

public final class ThreadLocalUtil {
    private static final String SYNC_INVOKE_TYPE = "SYNC";
    public static final String FUTURE_INVOKE_TYPE = "FUTURE";
    public static ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>(4);
        }
    };
    private static ThreadLocal<String> invokeType = new ThreadLocal();

    public static <T> T get(String key) {
        Map<String, Object> map = threadLocal.get();
        return (T)map.get(key);
    }

    public static void set(String key, Object value) {
        Map<String, Object> map = threadLocal.get();
        map.put(key, value);
    }

    public static void set(Map<String, Object> keyValueMap) {
        Map<String, Object> map = threadLocal.get();
        map.putAll(keyValueMap);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static <T> T remove(String key) {
        Map<String, Object> map = threadLocal.get();
        return (T)map.remove(key);
    }

    @Deprecated
    public static Boolean isNotSync() {
        return invokeType.get() == null || !SYNC_INVOKE_TYPE.equals(invokeType.get());
    }

    public static void convertToSync() {
        invokeType.set(SYNC_INVOKE_TYPE);
    }

    @Deprecated
    public static void clearSyncSet() {
        invokeType.set(null);
    }

    public static String getInvokeType() {
        return invokeType.get();
    }

    public static void convertToFuture() {
        invokeType.set(FUTURE_INVOKE_TYPE);
    }

    public static void clearInvokeTypeSet() {
        invokeType.set(null);
    }

    @Deprecated
    public static void clearFutureSet() {
        invokeType.set(null);
    }
}

