/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import java.util.Arrays;
import java.util.Random;

public class WeightMeta<T> {
    private final Random ran = new Random();
    private final T[] nodes;
    private final int[] weights;
    private final int maxW;

    public WeightMeta(T[] nodes, int[] weights) {
        this.nodes = nodes;
        this.weights = weights;
        this.maxW = weights[weights.length - 1];
    }

    public T random() {
        int index = Arrays.binarySearch(this.weights, this.ran.nextInt(this.maxW) + 1);
        if (index < 0) {
            index = -1 - index;
        }
        return this.nodes[index];
    }

    public T random(int ranInt) {
        ranInt = ranInt > this.maxW ? this.maxW : (ranInt < 0 ? 1 : ++ranInt);
        int index = Arrays.binarySearch(this.weights, ranInt);
        if (index < 0) {
            index = -1 - index;
        }
        return this.nodes[index];
    }

    public String toString() {
        StringBuilder l1 = new StringBuilder();
        StringBuilder l2 = new StringBuilder("[random]\t");
        StringBuilder l3 = new StringBuilder("[node]\t\t");
        l1.append(this.getClass().getName()).append(":").append(this.hashCode()).append(":\n").append("[index]\t\t");
        for (int i = 0; i < this.weights.length; ++i) {
            l1.append(i).append("\t");
            l2.append(this.weights[i]).append("\t");
            l3.append(this.nodes[i]).append("\t");
        }
        l1.append("\n");
        l2.append("\n");
        l3.append("\n");
        return l1.append((CharSequence)l2).append((CharSequence)l3).toString();
    }
}

