/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Preconditions;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.command.CommandResult;
import io.airlift.command.OutputProcessor;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ProcessCallable
implements Callable<CommandResult> {
    private final Command command;
    private final Executor executor;

    public ProcessCallable(Command command, Executor executor) {
        this.command = (Command)Preconditions.checkNotNull((Object)command, (Object)"command is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult call() throws CommandFailedException, InterruptedException {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(this.command.getCommand());
        processBuilder.directory(this.command.getDirectory());
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().putAll(this.command.getEnvironment());
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new CommandFailedException(this.command, "failed to start", e);
        }
        OutputProcessor outputProcessor = null;
        try {
            outputProcessor = new OutputProcessor(process, this.executor);
            outputProcessor.start();
            int exitCode = process.waitFor();
            String out = outputProcessor.getOutput();
            if (!this.command.getSuccessfulExitCodes().contains(exitCode)) {
                throw new CommandFailedException(this.command, exitCode, out);
            }
            CommandResult commandResult = new CommandResult(exitCode, out);
            return commandResult;
        }
        finally {
            try {
                process.destroy();
            }
            finally {
                if (outputProcessor != null) {
                    outputProcessor.destroy();
                }
            }
        }
    }
}

