/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.asyncapi.models;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IExternalDocumentationParent;
import io.apicurio.datamodels.core.models.common.Schema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AaiSchema
extends Schema
implements IExternalDocumentationParent {
    public String format;
    public String title;
    public String description;
    public Object default_;
    public Number multipleOf;
    public Number maximum;
    public Boolean exclusiveMaximum;
    public Number minimum;
    public Boolean exclusiveMinimum;
    public Number maxLength;
    public Number minLength;
    public String pattern;
    public Number maxItems;
    public Number minItems;
    public Boolean uniqueItems;
    public Number maxProperties;
    public Number minProperties;
    public List<String> required;
    public List<Object> enum_;
    public String type;
    public Object items;
    public List<AaiSchema> allOf;
    public List<AaiSchema> oneOf;
    public List<AaiSchema> anyOf;
    public AaiSchema not;
    public Map<String, AaiSchema> properties;
    public Object additionalProperties;
    public Boolean readOnly;
    public Boolean writeOnly;
    public String discriminator;
    public Boolean deprecated;
    public ExternalDocumentation externalDocs;
    public Object example;

    @Override
    public abstract ExternalDocumentation createExternalDocumentation();

    @Override
    public void setExternalDocumentation(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public abstract AaiSchema createAllOfSchema();

    public abstract AaiSchema createOneOfSchema();

    public abstract AaiSchema createAnyOfSchema();

    public abstract AaiSchema createNotSchema();

    public abstract AaiSchema createItemsSchema();

    public abstract AaiSchema createAdditionalPropertiesSchema();

    public abstract AaiSchema createPropertySchema(String var1);

    public List<String> getPropertyNames() {
        ArrayList<String> rval = new ArrayList<String>();
        if (this.properties != null) {
            rval.addAll(this.properties.keySet());
        }
        return rval;
    }

    public List<AaiSchema> getProperties() {
        ArrayList<AaiSchema> rval = new ArrayList<AaiSchema>();
        if (this.properties != null) {
            rval.addAll(this.properties.values());
        }
        return rval;
    }

    public AaiSchema addProperty(String propertyName, AaiSchema schema) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, AaiSchema>();
        }
        this.properties.put(propertyName, schema);
        return schema;
    }

    public AaiSchema removeProperty(String propertyName) {
        if (this.properties != null) {
            return this.properties.remove(propertyName);
        }
        return null;
    }

    public AaiSchema getProperty(String propertyName) {
        if (this.properties != null) {
            return this.properties.get(propertyName);
        }
        return null;
    }

    public boolean hasItemsSchema() {
        return NodeCompat.isNode(this.items);
    }

    public boolean hasItemsSchemas() {
        return NodeCompat.isList(this.items);
    }

    public boolean hasAdditionalPropertiesSchema() {
        return NodeCompat.isNode(this.additionalProperties);
    }

    public boolean hasAdditionalPropertiesBoolean() {
        return this.additionalProperties != null && !NodeCompat.isNode(this.additionalProperties);
    }

    public void addAllOfSchema(AaiSchema schema) {
        if (this.allOf == null) {
            this.allOf = new ArrayList<AaiSchema>();
        }
        this.allOf.add(schema);
    }

    public void addOneOfSchema(AaiSchema schema) {
        if (this.oneOf == null) {
            this.oneOf = new ArrayList<AaiSchema>();
        }
        this.oneOf.add(schema);
    }

    public void addAnyOfSchema(AaiSchema schema) {
        if (this.anyOf == null) {
            this.anyOf = new ArrayList<AaiSchema>();
        }
        this.anyOf.add(schema);
    }

    public void removeAllOfSchema(AaiSchema schema) {
        if (this.allOf != null) {
            this.allOf.remove(schema);
        }
    }

    public void removeOneOfSchema(AaiSchema schema) {
        if (this.oneOf != null) {
            this.oneOf.remove(schema);
        }
    }

    public void removeAnyOfSchema(AaiSchema schema) {
        if (this.anyOf != null) {
            this.anyOf.remove(schema);
        }
    }
}

