/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.visitors.dereference;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.ModernSecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExampleDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30ParameterDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBodyDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30ResponseDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import io.apicurio.datamodels.openapi.visitors.dereference.AbstractReferenceLocalizationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.IReferenceManipulationStrategy;
import java.util.LinkedHashMap;
import java.util.Map;

public class Oas30IReferenceManipulationStrategy
extends AbstractReferenceLocalizationStrategy
implements IReferenceManipulationStrategy {
    @Override
    public IReferenceManipulationStrategy.ReferenceAndNode attachAsDefinition(Document document, String name, Node component) {
        if (!(document instanceof Oas30Document)) {
            throw new IllegalArgumentException("Oas30Document expected.");
        }
        Oas30Document model = (Oas30Document)document;
        if (component instanceof Oas30Schema) {
            if (model.components.getSchemaDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30SchemaDefinition definition = this.wrap(component, new Oas30SchemaDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addSchemaDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "schemas/" + name, definition);
        }
        if (component instanceof Oas30Response) {
            if (model.components.getResponseDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30ResponseDefinition definition = this.wrap(component, new Oas30ResponseDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addResponseDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "responses/" + name, definition);
        }
        if (component instanceof Oas30Parameter) {
            if (model.components.getParameterDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30ParameterDefinition definition = this.wrap(component, new Oas30ParameterDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addParameterDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "parameters/" + name, definition);
        }
        if (component instanceof Oas30Example) {
            if (model.components.getExampleDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30ExampleDefinition definition = this.wrap(component, new Oas30ExampleDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addExampleDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "examples/" + name, definition);
        }
        if (component instanceof Oas30RequestBody) {
            if (model.components.getRequestBodyDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30RequestBodyDefinition definition = this.wrap(component, new Oas30RequestBodyDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addRequestBodyDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "requestBodies/" + name, definition);
        }
        if (component instanceof Oas30Header) {
            if (model.components.getHeaderDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30HeaderDefinition definition = this.wrap(component, new Oas30HeaderDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addHeaderDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "headers/" + name, definition);
        }
        if (component instanceof ModernSecurityScheme) {
            if (model.components.getSecurityScheme(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30SecurityScheme definition = this.wrap(component, new Oas30SecurityScheme(name), model);
            definition.attachToParent(model.components);
            model.components.addSecurityScheme(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "securitySchemes/" + name, definition);
        }
        if (component instanceof Oas30Link) {
            if (model.components.getLinkDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30LinkDefinition definition = this.wrap(component, new Oas30LinkDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addLinkDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "links/" + name, definition);
        }
        if (component instanceof Oas30Callback) {
            if (model.components.getCallbackDefinition(name) != null) {
                throw new IllegalArgumentException("Definition with that name already exists: " + name);
            }
            Oas30CallbackDefinition definition = this.wrap(component, new Oas30CallbackDefinition(name), model);
            definition.attachToParent(model.components);
            model.components.addCallbackDefinition(definition.getName(), definition);
            return new IReferenceManipulationStrategy.ReferenceAndNode(this.PREFIX + "callbacks/" + name, definition);
        }
        return null;
    }

    @Override
    public Map<String, Node> getExistingLocalComponents(Document document) {
        if (!(document instanceof Oas30Document)) {
            throw new IllegalArgumentException("Oas30Document expected.");
        }
        Oas30Document model = (Oas30Document)document;
        LinkedHashMap<String, Node> res = new LinkedHashMap<String, Node>();
        if (model.components != null) {
            this.transform(model.components.schemas, name -> this.PREFIX + "schemas/" + name, res);
            this.transform(model.components.responses, name -> this.PREFIX + "responses/" + name, res);
            this.transform(model.components.parameters, name -> this.PREFIX + "parameters/" + name, res);
            this.transform(model.components.examples, name -> this.PREFIX + "examples/" + name, res);
            this.transform(model.components.requestBodies, name -> this.PREFIX + "requestBodies/" + name, res);
            this.transform(model.components.headers, name -> this.PREFIX + "headers/" + name, res);
            this.transform(model.components.securitySchemes, name -> this.PREFIX + "securitySchemes/" + name, res);
            this.transform(model.components.links, name -> this.PREFIX + "links/" + name, res);
            this.transform(model.components.callbacks, name -> this.PREFIX + "callbacks/" + name, res);
        }
        return res;
    }
}

