/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.apimatic.core.utilities.LocalDateTimeHelper;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public final class OptionalNullable<T> {
    private T value;

    private OptionalNullable(T value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }

    public static <T> OptionalNullable<T> of(T value) {
        return new OptionalNullable<T>(value);
    }

    public static <T> T getFrom(OptionalNullable<T> optionalNullable) {
        return optionalNullable == null ? null : (T)optionalNullable.value;
    }

    public static class SimpleDateSerializer
    extends JsonSerializer<OptionalNullable<Object>> {
        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (((OptionalNullable)object).value instanceof List) {
                jgen.writeObject(LocalDateTimeHelper.toSimpleDate((List)((OptionalNullable)object).value));
            } else if (((OptionalNullable)object).value instanceof Map) {
                jgen.writeObject(LocalDateTimeHelper.toSimpleDate((Map)((OptionalNullable)object).value));
            } else {
                jgen.writeString(LocalDateTimeHelper.toSimpleDate((LocalDate)((OptionalNullable)object).value));
            }
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends JsonSerializer<OptionalNullable<Object>> {
        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (((OptionalNullable)object).value instanceof List) {
                jgen.writeObject(LocalDateTimeHelper.toRfc8601DateTime((List)((OptionalNullable)object).value));
            } else if (((OptionalNullable)object).value instanceof Map) {
                jgen.writeObject(LocalDateTimeHelper.toRfc8601DateTime((Map)((OptionalNullable)object).value));
            } else {
                jgen.writeString(LocalDateTimeHelper.toRfc8601DateTime((LocalDateTime)((OptionalNullable)object).value));
            }
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends JsonSerializer<OptionalNullable<Object>> {
        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (((OptionalNullable)object).value instanceof List) {
                jgen.writeObject(LocalDateTimeHelper.toRfc1123DateTime((List)((OptionalNullable)object).value));
            } else if (((OptionalNullable)object).value instanceof Map) {
                jgen.writeObject(LocalDateTimeHelper.toRfc1123DateTime((Map)((OptionalNullable)object).value));
            } else {
                jgen.writeString(LocalDateTimeHelper.toRfc1123DateTime((LocalDateTime)((OptionalNullable)object).value));
            }
        }
    }

    public static class UnixTimestampSerializer
    extends JsonSerializer<OptionalNullable<Object>> {
        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (((OptionalNullable)object).value instanceof List) {
                jgen.writeObject(LocalDateTimeHelper.toUnixTimestampLong((List)((OptionalNullable)object).value));
            } else if (((OptionalNullable)object).value instanceof Map) {
                jgen.writeObject(LocalDateTimeHelper.toUnixTimestampLong((Map)((OptionalNullable)object).value));
            } else {
                jgen.writeObject((Object)LocalDateTimeHelper.toUnixTimestampLong((LocalDateTime)((OptionalNullable)object).value));
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<OptionalNullable<Object>> {
        public void serialize(OptionalNullable<Object> object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(((OptionalNullable)object).value);
        }
    }
}

