/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.types.CoreApiException;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.type.functional.ExceptionCreator;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonStructure;

public final class ErrorCase<ExceptionType extends CoreApiException> {
    public static final String DEFAULT = "DEFAULT";
    private String reason;
    private boolean isErrorTemplate;
    private ExceptionCreator<ExceptionType> exceptionCreator;

    private ErrorCase(String reason, ExceptionCreator<ExceptionType> exceptionCreator, boolean isErrorTemplate) {
        this.reason = reason;
        this.exceptionCreator = exceptionCreator;
        this.isErrorTemplate = isErrorTemplate;
    }

    public void throwException(Context httpContext) throws ExceptionType {
        if (this.isErrorTemplate) {
            this.replacePlaceHolder(httpContext.getResponse());
        }
        throw (CoreApiException)this.exceptionCreator.apply(this.reason, httpContext);
    }

    public static <ExceptionType extends CoreApiException> ErrorCase<ExceptionType> setReason(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        ErrorCase<ExceptionType> errorCase = new ErrorCase<ExceptionType>(reason, exceptionCreator, false);
        return errorCase;
    }

    public static <ExceptionType extends CoreApiException> ErrorCase<ExceptionType> setTemplate(String reason, ExceptionCreator<ExceptionType> exceptionCreator) {
        return new ErrorCase<ExceptionType>(reason, exceptionCreator, true);
    }

    private void replacePlaceHolder(Response response) {
        this.replaceStatusCodeFromTemplate(response.getStatusCode());
        this.replaceHeadersFromTemplate(response.getHeaders());
        this.replaceBodyFromTemplate(response.getBody());
    }

    private void replaceHeadersFromTemplate(HttpHeaders headers) {
        StringBuilder formatter = new StringBuilder(this.reason);
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(this.reason);
        while (matcher.find()) {
            String key = matcher.group(1);
            String pointerKey = key;
            if (!pointerKey.startsWith("$response.header.")) continue;
            pointerKey = pointerKey.replace("$response.header.", "");
            String formatKey = String.format("{%s}", key);
            int index = formatter.indexOf(formatKey);
            pointerKey = pointerKey.toLowerCase();
            if (index == -1) continue;
            formatter.replace(index, index + formatKey.length(), "" + (headers.has(pointerKey) ? headers.value(pointerKey) : ""));
        }
        this.reason = formatter.toString();
    }

    private void replaceBodyFromTemplate(String responseBody) {
        StringBuilder formatter = new StringBuilder(this.reason);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(responseBody));
        JsonStructure jsonStructure = null;
        try {
            jsonStructure = jsonReader.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        jsonReader.close();
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(this.reason);
        while (matcher.find()) {
            String key;
            String pointerKey = key = matcher.group(1);
            this.replaceBodyString(responseBody, formatter, jsonStructure, key, pointerKey);
        }
        this.reason = formatter.toString().replaceAll("\"", "");
    }

    private void replaceBodyString(String responseBody, StringBuilder formatter, JsonStructure jsonStructure, String key, String pointerKey) {
        if (pointerKey.startsWith("$response.body")) {
            String formatKey = String.format("{%s}", key);
            int index = formatter.indexOf(formatKey);
            String toReplaceString = "";
            toReplaceString = this.extractReplacementString(responseBody, jsonStructure, pointerKey, toReplaceString);
            if (index != -1) {
                try {
                    formatter.replace(index, index + formatKey.length(), toReplaceString);
                }
                catch (JsonException ex) {
                    formatter.replace(index, index + formatKey.length(), "");
                }
            }
        }
    }

    private String extractReplacementString(String responseBody, JsonStructure jsonStructure, String pointerKey, String toReplaceString) {
        if (pointerKey.contains("#")) {
            pointerKey = pointerKey.replace("$response.body#", "");
            JsonPointer jsonPointer = Json.createPointer((String)pointerKey);
            if (jsonStructure != null && jsonPointer.containsValue(jsonStructure)) {
                toReplaceString = jsonPointer.getValue(jsonStructure).toString();
            }
        } else if (responseBody != null && !responseBody.isEmpty()) {
            toReplaceString = responseBody;
        }
        return toReplaceString;
    }

    private void replaceStatusCodeFromTemplate(int statusCode) {
        StringBuilder formatter = new StringBuilder(this.reason);
        Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(this.reason);
        while (matcher.find()) {
            String formatKey;
            int index;
            String key = matcher.group(1);
            if (!key.equals("$statusCode") || (index = formatter.indexOf(formatKey = String.format("{%s}", key))) == -1) continue;
            formatter.replace(index, index + formatKey.length(), "" + statusCode);
        }
        this.reason = formatter.toString();
    }
}

