/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.apimatic.core.types.http.request.MultipartFileWrapper;
import io.apimatic.core.types.http.request.MultipartWrapper;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.HeaderLoggingPolicyLevel;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.LoggingLevel;
import io.apimatic.coreinterfaces.http.LoggingLevelType;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.logger.ApiLogger;
import io.apimatic.coreinterfaces.logger.configuration.ReadonlyLogging;
import io.apimatic.coreinterfaces.type.CoreFileWrapper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class HttpLogger
implements ApiLogger {
    private final ConcurrentHashMap<Request, RequestEntry> requestQueue = new ConcurrentHashMap();
    private Logger logger;
    private ReadonlyLogging config;
    private ObjectWriter writer;

    public HttpLogger(Logger logger, ReadonlyLogging config) {
        this.logger = logger;
        this.config = config;
        ObjectMapper mapper = new ObjectMapper(CoreHelper.getMapper()){};
        mapper.addMixIn(CoreFileWrapper.class, LoggingMixIn.class);
        mapper.addMixIn(MultipartWrapper.class, LoggingMixIn.class);
        mapper.addMixIn(MultipartFileWrapper.class, LoggingMixIn.class);
        mapper.addMixIn(HttpHeaders.class, LoggingMixIn.class);
        this.writer = !config.isPrettyPrinting() ? mapper.writer() : mapper.writerWithDefaultPrettyPrinter();
    }

    public void logRequest(Request request, String url) {
        this.logRequest(request, url, null);
    }

    public void logRequest(Request request, String url, String additionalMessage) {
        if (request == null) {
            return;
        }
        String requestId = UUID.randomUUID().toString();
        RequestEntry requestEntry = new RequestEntry(requestId, System.nanoTime(), url);
        this.requestQueue.put(request, requestEntry);
        if (!(this.config.isLoggingRequestInfo() || this.config.isLoggingRequestHeaders() || this.config.isLoggingRequestBody())) {
            return;
        }
        RequestMessage message = new RequestMessage();
        message.setType("Request");
        message.setRequestId(requestId);
        if (this.config.isLoggingRequestInfo()) {
            message.method = request.getHttpMethod();
            message.setUrl(url);
            message.setAdditionalMessage(additionalMessage);
        }
        if (this.config.isLoggingRequestHeaders()) {
            message.setHeaders(this.getFilteredHeaders(request.getHeaders()));
        }
        if (this.config.isLoggingRequestBody()) {
            if (request.getBody() != null) {
                message.setBody(CoreHelper.deserializeAsObject(request.getBody().toString()));
            } else if (request.getParameters() != null && !request.getParameters().isEmpty()) {
                message.setBody(request.getParameters());
            }
        }
        this.log(message, this.config.getLevel(), true);
    }

    public void setError(Request request, Throwable error) {
        RequestEntry requestEntry = this.requestQueue.get(request);
        if (requestEntry != null) {
            requestEntry.error = error;
            this.requestQueue.put(request, requestEntry);
        }
    }

    public void logResponse(Request request, Response response) {
        this.logResponse(request, response, null);
    }

    public void logResponse(Request request, Response response, String additionalMessage) {
        RequestEntry requestEntry = this.requestQueue.get(request);
        if (requestEntry == null) {
            return;
        }
        this.requestQueue.remove(request);
        if (!(this.config.isLoggingResponseInfo() || this.config.isLoggingResponseHeaders() || this.config.isLoggingResponseBody())) {
            return;
        }
        ResponseMessage message = new ResponseMessage();
        message.setType("Response");
        message.setRequestId(requestEntry.requestId);
        long timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - requestEntry.startTime);
        if (response == null) {
            message.success = false;
            message.failureReason = "HTTP REQUEST FAILED: " + requestEntry.error;
            message.setUrl(requestEntry.url);
            message.timeTakenMillis = timeTaken;
            message.setAdditionalMessage(additionalMessage);
        } else {
            if (this.config.isLoggingResponseInfo()) {
                message.statusCode = response.getStatusCode();
                message.setUrl(requestEntry.url);
                message.timeTakenMillis = timeTaken;
                message.setAdditionalMessage(additionalMessage);
            }
            if (this.config.isLoggingResponseHeaders()) {
                message.setHeaders(this.getFilteredHeaders(response.getHeaders()));
            }
            if (this.config.isLoggingResponseBody()) {
                message.setBody(CoreHelper.deserializeAsObject(response.getBody()));
            }
        }
        this.log(message, this.config.getLevel(), true);
    }

    private Map<String, List<String>> getFilteredHeaders(HttpHeaders headers) {
        Map filteredHeders = headers.asMultimap();
        headers.names().forEach(name -> {
            boolean isNameInFilter = this.config.getHeaderFilters().contains(name);
            switch (HeaderLoggingPolicyLevel.valueOf((String)this.config.getHeaderLoggingPolicy().toString())) {
                case EXCLUDE: {
                    if (!isNameInFilter) break;
                    filteredHeders.remove(name);
                    break;
                }
                case INCLUDE: {
                    if (isNameInFilter) break;
                    filteredHeders.remove(name);
                    break;
                }
            }
        });
        return filteredHeders.isEmpty() ? null : filteredHeders;
    }

    private void log(Message message, LoggingLevel level, boolean logException) {
        block9: {
            try {
                String structuredMessage = this.writer.writeValueAsString((Object)message);
                switch (LoggingLevelType.valueOf((String)level.toString())) {
                    case ERROR: {
                        this.logger.error(structuredMessage);
                        break;
                    }
                    case WARN: {
                        this.logger.warn(structuredMessage);
                        break;
                    }
                    case INFO: {
                        this.logger.info(structuredMessage);
                        break;
                    }
                    case DEBUG: {
                        this.logger.debug(structuredMessage);
                        break;
                    }
                    case TRACE: {
                        this.logger.trace(structuredMessage);
                        break;
                    }
                }
            }
            catch (JsonProcessingException e) {
                if (!logException) break block9;
                message.body = "Unable to log body: " + e.toString();
                this.log(message, LoggingLevel.ERROR, false);
            }
        }
    }

    private class RequestEntry {
        private String requestId;
        private long startTime;
        private String url;
        private Throwable error;

        RequestEntry(String requestId, long startTime, String url) {
            this.requestId = requestId;
            this.startTime = startTime;
            this.url = url;
        }
    }

    private class Message {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String loggingError;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String type;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String requestId;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private Map<String, List<String>> headers;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private Object body;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String additionalMessage;

        private Message() {
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public void setAdditionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
        }
    }

    private class ResponseMessage
    extends Message {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private boolean success = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private String failureReason;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private Integer statusCode;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private Long timeTakenMillis;

        private ResponseMessage() {
        }
    }

    private class RequestMessage
    extends Message {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty
        private Method method;

        private RequestMessage() {
        }
    }

    private static interface LoggingMixIn {
        @JsonUnwrapped
        public String getHeaders();

        @JsonGetter(value="headers")
        public String asMultimap();

        @JsonIgnore
        public String getFile();

        @JsonGetter(value="file")
        public String getLoggableFile();

        @JsonIgnore
        public String getByteArray();

        @JsonGetter(value="object")
        public String getLoggableObject();
    }
}

