/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apimatic.core.utilities.CoreHelper;
import java.util.List;

public class CoreJsonValue {
    @JsonValue
    private final JsonNode value;

    @JsonCreator
    protected CoreJsonValue(JsonNode value) {
        this.value = value;
    }

    public static CoreJsonValue fromString(String value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue((JsonNode)TextNode.valueOf((String)value));
    }

    public static CoreJsonValue fromBoolean(Boolean value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue((JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static CoreJsonValue fromInteger(Integer value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue((JsonNode)IntNode.valueOf((int)value));
    }

    public static CoreJsonValue fromLong(Long value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue((JsonNode)LongNode.valueOf((long)value));
    }

    public static CoreJsonValue fromDouble(Double value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue((JsonNode)DoubleNode.valueOf((double)value));
    }

    public static CoreJsonValue fromObject(Object value) {
        if (value == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue(CoreHelper.getMapper().valueToTree(value));
    }

    public static <T> CoreJsonValue fromArray(List<T> values) {
        if (values == null) {
            return new CoreJsonValue(null);
        }
        return new CoreJsonValue(CoreHelper.getMapper().valueToTree(values));
    }

    public Object getStoredObject() {
        return CoreHelper.deserializeAsObject(this.toString());
    }

    public String toString() {
        try {
            return CoreHelper.getMapper().writeValueAsString((Object)this.value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

