/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.HttpRequest;
import io.apimatic.core.ResponseHandler;
import io.apimatic.core.configurations.http.request.EndpointConfiguration;
import io.apimatic.core.logger.SdkLoggerFactory;
import io.apimatic.core.request.async.AsyncExecutor;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.types.pagination.PageWrapper;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.request.configuration.CoreEndpointConfiguration;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.logger.ApiLogger;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ApiCall<ResponseType, ExceptionType extends CoreApiException> {
    private final GlobalConfiguration globalConfig;
    private final HttpRequest.Builder requestBuilder;
    private final ResponseHandler<ResponseType, ExceptionType> responseHandler;
    private final EndpointConfiguration endpointConfiguration;
    private final ApiLogger apiLogger;
    private Response response;

    private ApiCall(GlobalConfiguration globalConfig, EndpointConfiguration endpointConfiguration, HttpRequest.Builder requestBuilder, ResponseHandler<ResponseType, ExceptionType> responseHandler) {
        this.globalConfig = globalConfig;
        this.requestBuilder = requestBuilder;
        this.responseHandler = responseHandler;
        this.endpointConfiguration = endpointConfiguration;
        this.apiLogger = SdkLoggerFactory.getLogger(globalConfig.getLoggingConfiguration());
    }

    public <T, I, P> T paginate(Function<PaginatedData<I, P, ResponseType, ExceptionType>, T> converter, Function<PageWrapper<I, ResponseType>, P> responseToPage, Function<ResponseType, List<I>> responseToItems, PaginationStrategy ... strategies) {
        return converter.apply(new PaginatedData(this, responseToPage, responseToItems, strategies));
    }

    public Response getResponse() {
        return this.response;
    }

    public HttpRequest.Builder getRequestBuilder() {
        return this.requestBuilder.copy();
    }

    public ResponseType execute() throws IOException, ExceptionType {
        Request request = this.requestBuilder.build(this.globalConfig);
        this.apiLogger.logRequest(request);
        this.response = this.globalConfig.getHttpClient().execute(request, (CoreEndpointConfiguration)this.endpointConfiguration);
        this.apiLogger.logResponse(this.response);
        Context context = this.globalConfig.getCompatibilityFactory().createHttpContext(request, this.response);
        return this.responseHandler.handle(context, this.endpointConfiguration, this.globalConfig);
    }

    public CompletableFuture<ResponseType> executeAsync() {
        return AsyncExecutor.makeHttpCallAsync(() -> this.requestBuilder.build(this.globalConfig), request -> this.globalConfig.getHttpClient().executeAsync(request, (CoreEndpointConfiguration)this.endpointConfiguration), (req, res) -> {
            this.response = res;
            Context context = this.globalConfig.getCompatibilityFactory().createHttpContext(req, res);
            return this.responseHandler.handle(context, this.endpointConfiguration, this.globalConfig);
        }, this.apiLogger);
    }

    public Builder<ResponseType, ExceptionType> toBuilder() {
        Builder builder = new Builder();
        builder.globalConfig = this.globalConfig;
        builder.endpointConfigurationBuilder = this.endpointConfiguration.toBuilder();
        builder.responseHandlerBuilder = this.responseHandler.toBuilder();
        builder.requestBuilder = this.requestBuilder.copy();
        return builder;
    }

    public static class Builder<ResponseType, ExceptionType extends CoreApiException> {
        private GlobalConfiguration globalConfig;
        private HttpRequest.Builder requestBuilder = new HttpRequest.Builder();
        private ResponseHandler.Builder<ResponseType, ExceptionType> responseHandlerBuilder = new ResponseHandler.Builder();
        private EndpointConfiguration.Builder endpointConfigurationBuilder = new EndpointConfiguration.Builder();

        public Builder<ResponseType, ExceptionType> globalConfig(GlobalConfiguration globalConfig) {
            this.globalConfig = globalConfig;
            return this;
        }

        public Builder<ResponseType, ExceptionType> requestBuilder(Consumer<HttpRequest.Builder> action) {
            this.requestBuilder = new HttpRequest.Builder();
            action.accept(this.requestBuilder);
            return this;
        }

        public Builder<ResponseType, ExceptionType> requestBuilder(HttpRequest.Builder builder) {
            this.requestBuilder = builder;
            return this;
        }

        public Builder<ResponseType, ExceptionType> responseHandler(Consumer<ResponseHandler.Builder<ResponseType, ExceptionType>> action) {
            this.responseHandlerBuilder = new ResponseHandler.Builder();
            action.accept(this.responseHandlerBuilder);
            return this;
        }

        public Builder<ResponseType, ExceptionType> endpointConfiguration(Consumer<EndpointConfiguration.Builder> action) {
            this.endpointConfigurationBuilder = new EndpointConfiguration.Builder();
            action.accept(this.endpointConfigurationBuilder);
            return this;
        }

        public ApiCall<ResponseType, ExceptionType> build() {
            return new ApiCall(this.globalConfig, this.endpointConfigurationBuilder.build(), this.requestBuilder, this.responseHandlerBuilder.build());
        }
    }
}

