/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.request.async;

import io.apimatic.core.request.async.AsyncResponseHandler;
import io.apimatic.core.request.async.RequestExecutor;
import io.apimatic.core.request.async.RequestSupplier;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.logger.ApiLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class AsyncExecutor {
    private AsyncExecutor() {
    }

    public static <ResponseType, ExceptionType extends CoreApiException> CompletableFuture<ResponseType> makeHttpCallAsync(RequestSupplier requestSupplier, RequestExecutor requestExecutor, AsyncResponseHandler<ResponseType, ExceptionType> responseHandler, ApiLogger apiLogger) {
        Request request;
        try {
            request = requestSupplier.supply();
            apiLogger.logRequest(request);
        }
        catch (Exception e) {
            CompletableFuture futureResponse = new CompletableFuture();
            futureResponse.completeExceptionally(e);
            return futureResponse;
        }
        return requestExecutor.execute(request).thenApplyAsync(response -> {
            apiLogger.logResponse(response);
            try {
                return responseHandler.handle(request, (Response)response);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }
}

