/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.log4j2;

import io.basc.framework.lang.Nullable;
import io.basc.framework.log4j2.LevelCodec;
import io.basc.framework.logger.Logger;
import io.basc.framework.util.PlaceholderMessage;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4j2Logger
implements Logger {
    private final org.apache.logging.log4j.Logger logger;
    private final String placeholder;

    public Log4j2Logger(org.apache.logging.log4j.Logger logger, @Nullable String placeholder) {
        this.placeholder = placeholder;
        this.logger = logger;
    }

    public void setLevel(java.util.logging.Level level) {
        Configurator.setLevel((org.apache.logging.log4j.Logger)this.logger, (Level)LevelCodec.INSTANCE.encode(level));
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(LevelCodec.INSTANCE.encode(level));
    }

    public void log(LogRecord record) {
        Level lv = LevelCodec.INSTANCE.encode(record.getLevel());
        this.logger.log(lv, (Object)new PlaceholderMessage((Object)record.getMessage(), this.placeholder, record.getParameters()), record.getThrown());
    }
}

