/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.ClassMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClassMetaCache {
    private final Map<String, ClassMeta> cache = new HashMap<String, ClassMeta>();
    private final Map<String, ClassMeta> fallbackCache = new HashMap<String, ClassMeta>();
    private int fallbackHits;

    public ClassMetaCache() {
        this.cache.put("io/ebean/Model", new ModelMeta());
    }

    public ClassMeta get(String name) {
        return this.cache.get(name);
    }

    public void put(String name, ClassMeta meta) {
        this.cache.put(name, meta);
    }

    public ClassMeta getFallback(String className) {
        ClassMeta meta = this.fallbackCache.get(className);
        if (meta != null) {
            ++this.fallbackHits;
        }
        return meta;
    }

    public Set<String> fallbackKeys() {
        return this.fallbackCache.keySet();
    }

    public void setFallback() {
        Collection<ClassMeta> values = this.cache.values();
        for (ClassMeta value : values) {
            if (!value.isMappedSuper()) continue;
            this.fallbackCache.put(value.getClassName(), value);
        }
        this.cache.clear();
    }

    public Map<String, ClassMeta> getCache() {
        return this.cache;
    }

    public Map<String, ClassMeta> getFallbackCache() {
        return this.fallbackCache;
    }

    public int getFallbackHits() {
        return this.fallbackHits;
    }

    static class ModelMeta
    extends ClassMeta {
        ModelMeta() {
            super(null, 0, null);
            this.setClassName("io/ebean/Model", "java/lang/Object");
        }

        @Override
        public boolean isCheckSuperClassForEntity() {
            return false;
        }

        @Override
        public boolean isSuperClassEntity() {
            return false;
        }
    }
}

