// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/listener/v4alpha/listener_components.proto

package io.envoyproxy.envoy.config.listener.v4alpha;

/**
 * <pre>
 * Specifies the match criteria for selecting a specific filter chain for a
 * listener.
 * In order for a filter chain to be selected, *ALL* of its criteria must be
 * fulfilled by the incoming connection, properties of which are set by the
 * networking stack and/or listener filters.
 * The following order applies:
 * 1. Destination port.
 * 2. Destination IP address.
 * 3. Server name (e.g. SNI for TLS protocol),
 * 4. Transport protocol.
 * 5. Application protocols (e.g. ALPN for TLS protocol).
 * 6. Source type (e.g. any, local or external network).
 * 7. Source IP address.
 * 8. Source port.
 * For criteria that allow ranges or wildcards, the most specific value in any
 * of the configured filter chains that matches the incoming connection is going
 * to be used (e.g. for SNI ``www.example.com`` the most specific match would be
 * ``www.example.com``, then ``*.example.com``, then ``*.com``, then any filter
 * chain without ``server_names`` requirements).
 * [#comment: Implemented rules are kept in the preference order, with deprecated fields
 * listed at the end, because that's how we want to list them in the docs.
 * [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
 * [#next-free-field: 13]
 * </pre>
 *
 * Protobuf type {@code envoy.config.listener.v4alpha.FilterChainMatch}
 */
public  final class FilterChainMatch extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.listener.v4alpha.FilterChainMatch)
    FilterChainMatchOrBuilder {
private static final long serialVersionUID = 0L;
  // Use FilterChainMatch.newBuilder() to construct.
  private FilterChainMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private FilterChainMatch() {
    prefixRanges_ = java.util.Collections.emptyList();
    addressSuffix_ = "";
    sourceType_ = 0;
    sourcePrefixRanges_ = java.util.Collections.emptyList();
    sourcePorts_ = emptyIntList();
    serverNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    transportProtocol_ = "";
    applicationProtocols_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new FilterChainMatch();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private FilterChainMatch(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 26: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              prefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v4alpha.CidrRange>();
              mutable_bitField0_ |= 0x00000001;
            }
            prefixRanges_.add(
                input.readMessage(io.envoyproxy.envoy.config.core.v4alpha.CidrRange.parser(), extensionRegistry));
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            addressSuffix_ = s;
            break;
          }
          case 42: {
            com.google.protobuf.UInt32Value.Builder subBuilder = null;
            if (suffixLen_ != null) {
              subBuilder = suffixLen_.toBuilder();
            }
            suffixLen_ = input.readMessage(com.google.protobuf.UInt32Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(suffixLen_);
              suffixLen_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              sourcePrefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v4alpha.CidrRange>();
              mutable_bitField0_ |= 0x00000002;
            }
            sourcePrefixRanges_.add(
                input.readMessage(io.envoyproxy.envoy.config.core.v4alpha.CidrRange.parser(), extensionRegistry));
            break;
          }
          case 56: {
            if (!((mutable_bitField0_ & 0x00000004) != 0)) {
              sourcePorts_ = newIntList();
              mutable_bitField0_ |= 0x00000004;
            }
            sourcePorts_.addInt(input.readUInt32());
            break;
          }
          case 58: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000004) != 0) && input.getBytesUntilLimit() > 0) {
              sourcePorts_ = newIntList();
              mutable_bitField0_ |= 0x00000004;
            }
            while (input.getBytesUntilLimit() > 0) {
              sourcePorts_.addInt(input.readUInt32());
            }
            input.popLimit(limit);
            break;
          }
          case 66: {
            com.google.protobuf.UInt32Value.Builder subBuilder = null;
            if (destinationPort_ != null) {
              subBuilder = destinationPort_.toBuilder();
            }
            destinationPort_ = input.readMessage(com.google.protobuf.UInt32Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(destinationPort_);
              destinationPort_ = subBuilder.buildPartial();
            }

            break;
          }
          case 74: {
            java.lang.String s = input.readStringRequireUtf8();

            transportProtocol_ = s;
            break;
          }
          case 82: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000010) != 0)) {
              applicationProtocols_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000010;
            }
            applicationProtocols_.add(s);
            break;
          }
          case 90: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000008) != 0)) {
              serverNames_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000008;
            }
            serverNames_.add(s);
            break;
          }
          case 96: {
            int rawValue = input.readEnum();

            sourceType_ = rawValue;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        prefixRanges_ = java.util.Collections.unmodifiableList(prefixRanges_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        sourcePrefixRanges_ = java.util.Collections.unmodifiableList(sourcePrefixRanges_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        sourcePorts_.makeImmutable(); // C
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        applicationProtocols_ = applicationProtocols_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        serverNames_ = serverNames_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.listener.v4alpha.ListenerComponentsProto.internal_static_envoy_config_listener_v4alpha_FilterChainMatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.listener.v4alpha.ListenerComponentsProto.internal_static_envoy_config_listener_v4alpha_FilterChainMatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.class, io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.Builder.class);
  }

  /**
   * Protobuf enum {@code envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType}
   */
  public enum ConnectionSourceType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Any connection source matches.
     * </pre>
     *
     * <code>ANY = 0;</code>
     */
    ANY(0),
    /**
     * <pre>
     * Match a connection originating from the same host.
     * </pre>
     *
     * <code>SAME_IP_OR_LOOPBACK = 1;</code>
     */
    SAME_IP_OR_LOOPBACK(1),
    /**
     * <pre>
     * Match a connection originating from a different host.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    EXTERNAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Any connection source matches.
     * </pre>
     *
     * <code>ANY = 0;</code>
     */
    public static final int ANY_VALUE = 0;
    /**
     * <pre>
     * Match a connection originating from the same host.
     * </pre>
     *
     * <code>SAME_IP_OR_LOOPBACK = 1;</code>
     */
    public static final int SAME_IP_OR_LOOPBACK_VALUE = 1;
    /**
     * <pre>
     * Match a connection originating from a different host.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    public static final int EXTERNAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionSourceType valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectionSourceType forNumber(int value) {
      switch (value) {
        case 0: return ANY;
        case 1: return SAME_IP_OR_LOOPBACK;
        case 2: return EXTERNAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectionSourceType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ConnectionSourceType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ConnectionSourceType>() {
            public ConnectionSourceType findValueByNumber(int number) {
              return ConnectionSourceType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConnectionSourceType[] VALUES = values();

    public static ConnectionSourceType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectionSourceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType)
  }

  public static final int DESTINATION_PORT_FIELD_NUMBER = 8;
  private com.google.protobuf.UInt32Value destinationPort_;
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   */
  public boolean hasDestinationPort() {
    return destinationPort_ != null;
  }
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   */
  public com.google.protobuf.UInt32Value getDestinationPort() {
    return destinationPort_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
  }
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   */
  public com.google.protobuf.UInt32ValueOrBuilder getDestinationPortOrBuilder() {
    return getDestinationPort();
  }

  public static final int PREFIX_RANGES_FIELD_NUMBER = 3;
  private java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> prefixRanges_;
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
   */
  public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> getPrefixRangesList() {
    return prefixRanges_;
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
   */
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
      getPrefixRangesOrBuilderList() {
    return prefixRanges_;
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
   */
  public int getPrefixRangesCount() {
    return prefixRanges_.size();
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.CidrRange getPrefixRanges(int index) {
    return prefixRanges_.get(index);
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder getPrefixRangesOrBuilder(
      int index) {
    return prefixRanges_.get(index);
  }

  public static final int ADDRESS_SUFFIX_FIELD_NUMBER = 4;
  private volatile java.lang.Object addressSuffix_;
  /**
   * <pre>
   * If non-empty, an IP address and suffix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>string address_suffix = 4;</code>
   */
  public java.lang.String getAddressSuffix() {
    java.lang.Object ref = addressSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      addressSuffix_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non-empty, an IP address and suffix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>string address_suffix = 4;</code>
   */
  public com.google.protobuf.ByteString
      getAddressSuffixBytes() {
    java.lang.Object ref = addressSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      addressSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUFFIX_LEN_FIELD_NUMBER = 5;
  private com.google.protobuf.UInt32Value suffixLen_;
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   */
  public boolean hasSuffixLen() {
    return suffixLen_ != null;
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   */
  public com.google.protobuf.UInt32Value getSuffixLen() {
    return suffixLen_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   */
  public com.google.protobuf.UInt32ValueOrBuilder getSuffixLenOrBuilder() {
    return getSuffixLen();
  }

  public static final int SOURCE_TYPE_FIELD_NUMBER = 12;
  private int sourceType_;
  /**
   * <pre>
   * Specifies the connection source IP match type. Can be any, local or external network.
   * </pre>
   *
   * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
   */
  public int getSourceTypeValue() {
    return sourceType_;
  }
  /**
   * <pre>
   * Specifies the connection source IP match type. Can be any, local or external network.
   * </pre>
   *
   * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
   */
  public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType getSourceType() {
    @SuppressWarnings("deprecation")
    io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType result = io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.valueOf(sourceType_);
    return result == null ? io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.UNRECOGNIZED : result;
  }

  public static final int SOURCE_PREFIX_RANGES_FIELD_NUMBER = 6;
  private java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> sourcePrefixRanges_;
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
   */
  public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> getSourcePrefixRangesList() {
    return sourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
   */
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
      getSourcePrefixRangesOrBuilderList() {
    return sourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
   */
  public int getSourcePrefixRangesCount() {
    return sourcePrefixRanges_.size();
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.CidrRange getSourcePrefixRanges(int index) {
    return sourcePrefixRanges_.get(index);
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
   */
  public io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder getSourcePrefixRangesOrBuilder(
      int index) {
    return sourcePrefixRanges_.get(index);
  }

  public static final int SOURCE_PORTS_FIELD_NUMBER = 7;
  private com.google.protobuf.Internal.IntList sourcePorts_;
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   */
  public java.util.List<java.lang.Integer>
      getSourcePortsList() {
    return sourcePorts_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   */
  public int getSourcePortsCount() {
    return sourcePorts_.size();
  }
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   */
  public int getSourcePorts(int index) {
    return sourcePorts_.getInt(index);
  }
  private int sourcePortsMemoizedSerializedSize = -1;

  public static final int SERVER_NAMES_FIELD_NUMBER = 11;
  private com.google.protobuf.LazyStringList serverNames_;
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * .. attention::
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getServerNamesList() {
    return serverNames_;
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * .. attention::
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   */
  public int getServerNamesCount() {
    return serverNames_.size();
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * .. attention::
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   */
  public java.lang.String getServerNames(int index) {
    return serverNames_.get(index);
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * .. attention::
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   */
  public com.google.protobuf.ByteString
      getServerNamesBytes(int index) {
    return serverNames_.getByteString(index);
  }

  public static final int TRANSPORT_PROTOCOL_FIELD_NUMBER = 9;
  private volatile java.lang.Object transportProtocol_;
  /**
   * <pre>
   * If non-empty, a transport protocol to consider when determining a filter chain match.
   * This value will be compared against the transport protocol of a new connection, when
   * it's detected by one of the listener filters.
   * Suggested values include:
   * * ``raw_buffer`` - default, used when no transport protocol is detected,
   * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *   when TLS protocol is detected.
   * </pre>
   *
   * <code>string transport_protocol = 9;</code>
   */
  public java.lang.String getTransportProtocol() {
    java.lang.Object ref = transportProtocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transportProtocol_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non-empty, a transport protocol to consider when determining a filter chain match.
   * This value will be compared against the transport protocol of a new connection, when
   * it's detected by one of the listener filters.
   * Suggested values include:
   * * ``raw_buffer`` - default, used when no transport protocol is detected,
   * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *   when TLS protocol is detected.
   * </pre>
   *
   * <code>string transport_protocol = 9;</code>
   */
  public com.google.protobuf.ByteString
      getTransportProtocolBytes() {
    java.lang.Object ref = transportProtocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      transportProtocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLICATION_PROTOCOLS_FIELD_NUMBER = 10;
  private com.google.protobuf.LazyStringList applicationProtocols_;
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   * Suggested values include:
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   * .. attention::
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getApplicationProtocolsList() {
    return applicationProtocols_;
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   * Suggested values include:
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   * .. attention::
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   */
  public int getApplicationProtocolsCount() {
    return applicationProtocols_.size();
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   * Suggested values include:
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   * .. attention::
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   */
  public java.lang.String getApplicationProtocols(int index) {
    return applicationProtocols_.get(index);
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   * Suggested values include:
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   * .. attention::
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   */
  public com.google.protobuf.ByteString
      getApplicationProtocolsBytes(int index) {
    return applicationProtocols_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < prefixRanges_.size(); i++) {
      output.writeMessage(3, prefixRanges_.get(i));
    }
    if (!getAddressSuffixBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, addressSuffix_);
    }
    if (suffixLen_ != null) {
      output.writeMessage(5, getSuffixLen());
    }
    for (int i = 0; i < sourcePrefixRanges_.size(); i++) {
      output.writeMessage(6, sourcePrefixRanges_.get(i));
    }
    if (getSourcePortsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(sourcePortsMemoizedSerializedSize);
    }
    for (int i = 0; i < sourcePorts_.size(); i++) {
      output.writeUInt32NoTag(sourcePorts_.getInt(i));
    }
    if (destinationPort_ != null) {
      output.writeMessage(8, getDestinationPort());
    }
    if (!getTransportProtocolBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, transportProtocol_);
    }
    for (int i = 0; i < applicationProtocols_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, applicationProtocols_.getRaw(i));
    }
    for (int i = 0; i < serverNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serverNames_.getRaw(i));
    }
    if (sourceType_ != io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.ANY.getNumber()) {
      output.writeEnum(12, sourceType_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < prefixRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, prefixRanges_.get(i));
    }
    if (!getAddressSuffixBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, addressSuffix_);
    }
    if (suffixLen_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getSuffixLen());
    }
    for (int i = 0; i < sourcePrefixRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, sourcePrefixRanges_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourcePorts_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(sourcePorts_.getInt(i));
      }
      size += dataSize;
      if (!getSourcePortsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      sourcePortsMemoizedSerializedSize = dataSize;
    }
    if (destinationPort_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getDestinationPort());
    }
    if (!getTransportProtocolBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, transportProtocol_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < applicationProtocols_.size(); i++) {
        dataSize += computeStringSizeNoTag(applicationProtocols_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getApplicationProtocolsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serverNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(serverNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServerNamesList().size();
    }
    if (sourceType_ != io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.ANY.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(12, sourceType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch other = (io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch) obj;

    if (hasDestinationPort() != other.hasDestinationPort()) return false;
    if (hasDestinationPort()) {
      if (!getDestinationPort()
          .equals(other.getDestinationPort())) return false;
    }
    if (!getPrefixRangesList()
        .equals(other.getPrefixRangesList())) return false;
    if (!getAddressSuffix()
        .equals(other.getAddressSuffix())) return false;
    if (hasSuffixLen() != other.hasSuffixLen()) return false;
    if (hasSuffixLen()) {
      if (!getSuffixLen()
          .equals(other.getSuffixLen())) return false;
    }
    if (sourceType_ != other.sourceType_) return false;
    if (!getSourcePrefixRangesList()
        .equals(other.getSourcePrefixRangesList())) return false;
    if (!getSourcePortsList()
        .equals(other.getSourcePortsList())) return false;
    if (!getServerNamesList()
        .equals(other.getServerNamesList())) return false;
    if (!getTransportProtocol()
        .equals(other.getTransportProtocol())) return false;
    if (!getApplicationProtocolsList()
        .equals(other.getApplicationProtocolsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDestinationPort()) {
      hash = (37 * hash) + DESTINATION_PORT_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationPort().hashCode();
    }
    if (getPrefixRangesCount() > 0) {
      hash = (37 * hash) + PREFIX_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getPrefixRangesList().hashCode();
    }
    hash = (37 * hash) + ADDRESS_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getAddressSuffix().hashCode();
    if (hasSuffixLen()) {
      hash = (37 * hash) + SUFFIX_LEN_FIELD_NUMBER;
      hash = (53 * hash) + getSuffixLen().hashCode();
    }
    hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + sourceType_;
    if (getSourcePrefixRangesCount() > 0) {
      hash = (37 * hash) + SOURCE_PREFIX_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePrefixRangesList().hashCode();
    }
    if (getSourcePortsCount() > 0) {
      hash = (37 * hash) + SOURCE_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePortsList().hashCode();
    }
    if (getServerNamesCount() > 0) {
      hash = (37 * hash) + SERVER_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getServerNamesList().hashCode();
    }
    hash = (37 * hash) + TRANSPORT_PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getTransportProtocol().hashCode();
    if (getApplicationProtocolsCount() > 0) {
      hash = (37 * hash) + APPLICATION_PROTOCOLS_FIELD_NUMBER;
      hash = (53 * hash) + getApplicationProtocolsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies the match criteria for selecting a specific filter chain for a
   * listener.
   * In order for a filter chain to be selected, *ALL* of its criteria must be
   * fulfilled by the incoming connection, properties of which are set by the
   * networking stack and/or listener filters.
   * The following order applies:
   * 1. Destination port.
   * 2. Destination IP address.
   * 3. Server name (e.g. SNI for TLS protocol),
   * 4. Transport protocol.
   * 5. Application protocols (e.g. ALPN for TLS protocol).
   * 6. Source type (e.g. any, local or external network).
   * 7. Source IP address.
   * 8. Source port.
   * For criteria that allow ranges or wildcards, the most specific value in any
   * of the configured filter chains that matches the incoming connection is going
   * to be used (e.g. for SNI ``www.example.com`` the most specific match would be
   * ``www.example.com``, then ``*.example.com``, then ``*.com``, then any filter
   * chain without ``server_names`` requirements).
   * [#comment: Implemented rules are kept in the preference order, with deprecated fields
   * listed at the end, because that's how we want to list them in the docs.
   * [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
   * [#next-free-field: 13]
   * </pre>
   *
   * Protobuf type {@code envoy.config.listener.v4alpha.FilterChainMatch}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.listener.v4alpha.FilterChainMatch)
      io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.listener.v4alpha.ListenerComponentsProto.internal_static_envoy_config_listener_v4alpha_FilterChainMatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.listener.v4alpha.ListenerComponentsProto.internal_static_envoy_config_listener_v4alpha_FilterChainMatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.class, io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getPrefixRangesFieldBuilder();
        getSourcePrefixRangesFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (destinationPortBuilder_ == null) {
        destinationPort_ = null;
      } else {
        destinationPort_ = null;
        destinationPortBuilder_ = null;
      }
      if (prefixRangesBuilder_ == null) {
        prefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        prefixRangesBuilder_.clear();
      }
      addressSuffix_ = "";

      if (suffixLenBuilder_ == null) {
        suffixLen_ = null;
      } else {
        suffixLen_ = null;
        suffixLenBuilder_ = null;
      }
      sourceType_ = 0;

      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        sourcePrefixRangesBuilder_.clear();
      }
      sourcePorts_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      serverNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      transportProtocol_ = "";

      applicationProtocols_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.listener.v4alpha.ListenerComponentsProto.internal_static_envoy_config_listener_v4alpha_FilterChainMatch_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch build() {
      io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch buildPartial() {
      io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch result = new io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch(this);
      int from_bitField0_ = bitField0_;
      if (destinationPortBuilder_ == null) {
        result.destinationPort_ = destinationPort_;
      } else {
        result.destinationPort_ = destinationPortBuilder_.build();
      }
      if (prefixRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          prefixRanges_ = java.util.Collections.unmodifiableList(prefixRanges_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.prefixRanges_ = prefixRanges_;
      } else {
        result.prefixRanges_ = prefixRangesBuilder_.build();
      }
      result.addressSuffix_ = addressSuffix_;
      if (suffixLenBuilder_ == null) {
        result.suffixLen_ = suffixLen_;
      } else {
        result.suffixLen_ = suffixLenBuilder_.build();
      }
      result.sourceType_ = sourceType_;
      if (sourcePrefixRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          sourcePrefixRanges_ = java.util.Collections.unmodifiableList(sourcePrefixRanges_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sourcePrefixRanges_ = sourcePrefixRanges_;
      } else {
        result.sourcePrefixRanges_ = sourcePrefixRangesBuilder_.build();
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        sourcePorts_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.sourcePorts_ = sourcePorts_;
      if (((bitField0_ & 0x00000008) != 0)) {
        serverNames_ = serverNames_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.serverNames_ = serverNames_;
      result.transportProtocol_ = transportProtocol_;
      if (((bitField0_ & 0x00000010) != 0)) {
        applicationProtocols_ = applicationProtocols_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.applicationProtocols_ = applicationProtocols_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch) {
        return mergeFrom((io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch other) {
      if (other == io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.getDefaultInstance()) return this;
      if (other.hasDestinationPort()) {
        mergeDestinationPort(other.getDestinationPort());
      }
      if (prefixRangesBuilder_ == null) {
        if (!other.prefixRanges_.isEmpty()) {
          if (prefixRanges_.isEmpty()) {
            prefixRanges_ = other.prefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePrefixRangesIsMutable();
            prefixRanges_.addAll(other.prefixRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.prefixRanges_.isEmpty()) {
          if (prefixRangesBuilder_.isEmpty()) {
            prefixRangesBuilder_.dispose();
            prefixRangesBuilder_ = null;
            prefixRanges_ = other.prefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
            prefixRangesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getPrefixRangesFieldBuilder() : null;
          } else {
            prefixRangesBuilder_.addAllMessages(other.prefixRanges_);
          }
        }
      }
      if (!other.getAddressSuffix().isEmpty()) {
        addressSuffix_ = other.addressSuffix_;
        onChanged();
      }
      if (other.hasSuffixLen()) {
        mergeSuffixLen(other.getSuffixLen());
      }
      if (other.sourceType_ != 0) {
        setSourceTypeValue(other.getSourceTypeValue());
      }
      if (sourcePrefixRangesBuilder_ == null) {
        if (!other.sourcePrefixRanges_.isEmpty()) {
          if (sourcePrefixRanges_.isEmpty()) {
            sourcePrefixRanges_ = other.sourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSourcePrefixRangesIsMutable();
            sourcePrefixRanges_.addAll(other.sourcePrefixRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.sourcePrefixRanges_.isEmpty()) {
          if (sourcePrefixRangesBuilder_.isEmpty()) {
            sourcePrefixRangesBuilder_.dispose();
            sourcePrefixRangesBuilder_ = null;
            sourcePrefixRanges_ = other.sourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
            sourcePrefixRangesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getSourcePrefixRangesFieldBuilder() : null;
          } else {
            sourcePrefixRangesBuilder_.addAllMessages(other.sourcePrefixRanges_);
          }
        }
      }
      if (!other.sourcePorts_.isEmpty()) {
        if (sourcePorts_.isEmpty()) {
          sourcePorts_ = other.sourcePorts_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureSourcePortsIsMutable();
          sourcePorts_.addAll(other.sourcePorts_);
        }
        onChanged();
      }
      if (!other.serverNames_.isEmpty()) {
        if (serverNames_.isEmpty()) {
          serverNames_ = other.serverNames_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureServerNamesIsMutable();
          serverNames_.addAll(other.serverNames_);
        }
        onChanged();
      }
      if (!other.getTransportProtocol().isEmpty()) {
        transportProtocol_ = other.transportProtocol_;
        onChanged();
      }
      if (!other.applicationProtocols_.isEmpty()) {
        if (applicationProtocols_.isEmpty()) {
          applicationProtocols_ = other.applicationProtocols_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureApplicationProtocolsIsMutable();
          applicationProtocols_.addAll(other.applicationProtocols_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.UInt32Value destinationPort_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> destinationPortBuilder_;
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public boolean hasDestinationPort() {
      return destinationPortBuilder_ != null || destinationPort_ != null;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.UInt32Value getDestinationPort() {
      if (destinationPortBuilder_ == null) {
        return destinationPort_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
      } else {
        return destinationPortBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setDestinationPort(com.google.protobuf.UInt32Value value) {
      if (destinationPortBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationPort_ = value;
        onChanged();
      } else {
        destinationPortBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setDestinationPort(
        com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (destinationPortBuilder_ == null) {
        destinationPort_ = builderForValue.build();
        onChanged();
      } else {
        destinationPortBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder mergeDestinationPort(com.google.protobuf.UInt32Value value) {
      if (destinationPortBuilder_ == null) {
        if (destinationPort_ != null) {
          destinationPort_ =
            com.google.protobuf.UInt32Value.newBuilder(destinationPort_).mergeFrom(value).buildPartial();
        } else {
          destinationPort_ = value;
        }
        onChanged();
      } else {
        destinationPortBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder clearDestinationPort() {
      if (destinationPortBuilder_ == null) {
        destinationPort_ = null;
        onChanged();
      } else {
        destinationPort_ = null;
        destinationPortBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.UInt32Value.Builder getDestinationPortBuilder() {
      
      onChanged();
      return getDestinationPortFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.UInt32ValueOrBuilder getDestinationPortOrBuilder() {
      if (destinationPortBuilder_ != null) {
        return destinationPortBuilder_.getMessageOrBuilder();
      } else {
        return destinationPort_ == null ?
            com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
      }
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
        getDestinationPortFieldBuilder() {
      if (destinationPortBuilder_ == null) {
        destinationPortBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                getDestinationPort(),
                getParentForChildren(),
                isClean());
        destinationPort_ = null;
      }
      return destinationPortBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> prefixRanges_ =
      java.util.Collections.emptyList();
    private void ensurePrefixRangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        prefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v4alpha.CidrRange>(prefixRanges_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> prefixRangesBuilder_;

    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> getPrefixRangesList() {
      if (prefixRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(prefixRanges_);
      } else {
        return prefixRangesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public int getPrefixRangesCount() {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.size();
      } else {
        return prefixRangesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange getPrefixRanges(int index) {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.get(index);
      } else {
        return prefixRangesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder setPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.set(index, value);
        onChanged();
      } else {
        prefixRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder setPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(value);
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(index, value);
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addAllPrefixRanges(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRange> values) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, prefixRanges_);
        onChanged();
      } else {
        prefixRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder clearPrefixRanges() {
      if (prefixRangesBuilder_ == null) {
        prefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        prefixRangesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public Builder removePrefixRanges(int index) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.remove(index);
        onChanged();
      } else {
        prefixRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder getPrefixRangesBuilder(
        int index) {
      return getPrefixRangesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder getPrefixRangesOrBuilder(
        int index) {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.get(index);  } else {
        return prefixRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
         getPrefixRangesOrBuilderList() {
      if (prefixRangesBuilder_ != null) {
        return prefixRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(prefixRanges_);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder addPrefixRangesBuilder() {
      return getPrefixRangesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v4alpha.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder addPrefixRangesBuilder(
        int index) {
      return getPrefixRangesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder> 
         getPrefixRangesBuilderList() {
      return getPrefixRangesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
        getPrefixRangesFieldBuilder() {
      if (prefixRangesBuilder_ == null) {
        prefixRangesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder>(
                prefixRanges_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        prefixRanges_ = null;
      }
      return prefixRangesBuilder_;
    }

    private java.lang.Object addressSuffix_ = "";
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     */
    public java.lang.String getAddressSuffix() {
      java.lang.Object ref = addressSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        addressSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     */
    public com.google.protobuf.ByteString
        getAddressSuffixBytes() {
      java.lang.Object ref = addressSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        addressSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     */
    public Builder setAddressSuffix(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      addressSuffix_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     */
    public Builder clearAddressSuffix() {
      
      addressSuffix_ = getDefaultInstance().getAddressSuffix();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     */
    public Builder setAddressSuffixBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      addressSuffix_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.UInt32Value suffixLen_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> suffixLenBuilder_;
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public boolean hasSuffixLen() {
      return suffixLenBuilder_ != null || suffixLen_ != null;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public com.google.protobuf.UInt32Value getSuffixLen() {
      if (suffixLenBuilder_ == null) {
        return suffixLen_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
      } else {
        return suffixLenBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder setSuffixLen(com.google.protobuf.UInt32Value value) {
      if (suffixLenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suffixLen_ = value;
        onChanged();
      } else {
        suffixLenBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder setSuffixLen(
        com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (suffixLenBuilder_ == null) {
        suffixLen_ = builderForValue.build();
        onChanged();
      } else {
        suffixLenBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder mergeSuffixLen(com.google.protobuf.UInt32Value value) {
      if (suffixLenBuilder_ == null) {
        if (suffixLen_ != null) {
          suffixLen_ =
            com.google.protobuf.UInt32Value.newBuilder(suffixLen_).mergeFrom(value).buildPartial();
        } else {
          suffixLen_ = value;
        }
        onChanged();
      } else {
        suffixLenBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder clearSuffixLen() {
      if (suffixLenBuilder_ == null) {
        suffixLen_ = null;
        onChanged();
      } else {
        suffixLen_ = null;
        suffixLenBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public com.google.protobuf.UInt32Value.Builder getSuffixLenBuilder() {
      
      onChanged();
      return getSuffixLenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public com.google.protobuf.UInt32ValueOrBuilder getSuffixLenOrBuilder() {
      if (suffixLenBuilder_ != null) {
        return suffixLenBuilder_.getMessageOrBuilder();
      } else {
        return suffixLen_ == null ?
            com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
        getSuffixLenFieldBuilder() {
      if (suffixLenBuilder_ == null) {
        suffixLenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                getSuffixLen(),
                getParentForChildren(),
                isClean());
        suffixLen_ = null;
      }
      return suffixLenBuilder_;
    }

    private int sourceType_ = 0;
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     */
    public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     */
    public Builder setSourceTypeValue(int value) {
      sourceType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType getSourceType() {
      @SuppressWarnings("deprecation")
      io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType result = io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.valueOf(sourceType_);
      return result == null ? io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     */
    public Builder setSourceType(io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      sourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v4alpha.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     */
    public Builder clearSourceType() {
      
      sourceType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> sourcePrefixRanges_ =
      java.util.Collections.emptyList();
    private void ensureSourcePrefixRangesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        sourcePrefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v4alpha.CidrRange>(sourcePrefixRanges_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> sourcePrefixRangesBuilder_;

    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange> getSourcePrefixRangesList() {
      if (sourcePrefixRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sourcePrefixRanges_);
      } else {
        return sourcePrefixRangesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public int getSourcePrefixRangesCount() {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.size();
      } else {
        return sourcePrefixRangesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange getSourcePrefixRanges(int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.get(index);
      } else {
        return sourcePrefixRangesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder setSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.set(index, value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder setSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(index, value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addAllSourcePrefixRanges(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRange> values) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, sourcePrefixRanges_);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder clearSourcePrefixRanges() {
      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder removeSourcePrefixRanges(int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.remove(index);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder getSourcePrefixRangesBuilder(
        int index) {
      return getSourcePrefixRangesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder getSourcePrefixRangesOrBuilder(
        int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.get(index);  } else {
        return sourcePrefixRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
         getSourcePrefixRangesOrBuilderList() {
      if (sourcePrefixRangesBuilder_ != null) {
        return sourcePrefixRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sourcePrefixRanges_);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder addSourcePrefixRangesBuilder() {
      return getSourcePrefixRangesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v4alpha.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder addSourcePrefixRangesBuilder(
        int index) {
      return getSourcePrefixRangesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v4alpha.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder> 
         getSourcePrefixRangesBuilderList() {
      return getSourcePrefixRangesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder> 
        getSourcePrefixRangesFieldBuilder() {
      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRangesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v4alpha.CidrRange, io.envoyproxy.envoy.config.core.v4alpha.CidrRange.Builder, io.envoyproxy.envoy.config.core.v4alpha.CidrRangeOrBuilder>(
                sourcePrefixRanges_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        sourcePrefixRanges_ = null;
      }
      return sourcePrefixRangesBuilder_;
    }

    private com.google.protobuf.Internal.IntList sourcePorts_ = emptyIntList();
    private void ensureSourcePortsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        sourcePorts_ = mutableCopy(sourcePorts_);
        bitField0_ |= 0x00000004;
       }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<java.lang.Integer>
        getSourcePortsList() {
      return ((bitField0_ & 0x00000004) != 0) ?
               java.util.Collections.unmodifiableList(sourcePorts_) : sourcePorts_;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public int getSourcePortsCount() {
      return sourcePorts_.size();
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public int getSourcePorts(int index) {
      return sourcePorts_.getInt(index);
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder setSourcePorts(
        int index, int value) {
      ensureSourcePortsIsMutable();
      sourcePorts_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addSourcePorts(int value) {
      ensureSourcePortsIsMutable();
      sourcePorts_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addAllSourcePorts(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureSourcePortsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, sourcePorts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder clearSourcePorts() {
      sourcePorts_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList serverNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureServerNamesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        serverNames_ = new com.google.protobuf.LazyStringArrayList(serverNames_);
        bitField0_ |= 0x00000008;
       }
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getServerNamesList() {
      return serverNames_.getUnmodifiableView();
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public int getServerNamesCount() {
      return serverNames_.size();
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public java.lang.String getServerNames(int index) {
      return serverNames_.get(index);
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public com.google.protobuf.ByteString
        getServerNamesBytes(int index) {
      return serverNames_.getByteString(index);
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public Builder setServerNames(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureServerNamesIsMutable();
      serverNames_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public Builder addServerNames(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureServerNamesIsMutable();
      serverNames_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public Builder addAllServerNames(
        java.lang.Iterable<java.lang.String> values) {
      ensureServerNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, serverNames_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public Builder clearServerNames() {
      serverNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * .. attention::
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     */
    public Builder addServerNamesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureServerNamesIsMutable();
      serverNames_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object transportProtocol_ = "";
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     * Suggested values include:
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     */
    public java.lang.String getTransportProtocol() {
      java.lang.Object ref = transportProtocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transportProtocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     * Suggested values include:
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     */
    public com.google.protobuf.ByteString
        getTransportProtocolBytes() {
      java.lang.Object ref = transportProtocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        transportProtocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     * Suggested values include:
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     */
    public Builder setTransportProtocol(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      transportProtocol_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     * Suggested values include:
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     */
    public Builder clearTransportProtocol() {
      
      transportProtocol_ = getDefaultInstance().getTransportProtocol();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     * Suggested values include:
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     */
    public Builder setTransportProtocolBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      transportProtocol_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList applicationProtocols_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureApplicationProtocolsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        applicationProtocols_ = new com.google.protobuf.LazyStringArrayList(applicationProtocols_);
        bitField0_ |= 0x00000010;
       }
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getApplicationProtocolsList() {
      return applicationProtocols_.getUnmodifiableView();
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public int getApplicationProtocolsCount() {
      return applicationProtocols_.size();
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public java.lang.String getApplicationProtocols(int index) {
      return applicationProtocols_.get(index);
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public com.google.protobuf.ByteString
        getApplicationProtocolsBytes(int index) {
      return applicationProtocols_.getByteString(index);
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public Builder setApplicationProtocols(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureApplicationProtocolsIsMutable();
      applicationProtocols_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public Builder addApplicationProtocols(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureApplicationProtocolsIsMutable();
      applicationProtocols_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public Builder addAllApplicationProtocols(
        java.lang.Iterable<java.lang.String> values) {
      ensureApplicationProtocolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, applicationProtocols_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public Builder clearApplicationProtocols() {
      applicationProtocols_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     * Suggested values include:
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     * .. attention::
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     */
    public Builder addApplicationProtocolsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureApplicationProtocolsIsMutable();
      applicationProtocols_.add(value);
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.listener.v4alpha.FilterChainMatch)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.listener.v4alpha.FilterChainMatch)
  private static final io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch();
  }

  public static io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FilterChainMatch>
      PARSER = new com.google.protobuf.AbstractParser<FilterChainMatch>() {
    @java.lang.Override
    public FilterChainMatch parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new FilterChainMatch(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<FilterChainMatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FilterChainMatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.listener.v4alpha.FilterChainMatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

