/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class ExecDetails {
    private static final String EXIT_CODE = "ExitCode";
    private static final String RUNNING = "Running";
    private static final String ENTRY_POINT = "entrypoint";
    private static final String ARGUMENTS = "arguments";
    private static final String PROCESS_CONFIG = "ProcessConfig";
    private final JsonObject json;

    public ExecDetails(JsonObject json) {
        this.json = json;
    }

    public boolean isRunning() {
        return this.json.get(RUNNING).getAsBoolean();
    }

    public Integer getExitCode() {
        if (this.isRunning()) {
            return null;
        }
        return this.json.get(EXIT_CODE).getAsInt();
    }

    public String getEntryPoint() {
        if (!this.json.has(PROCESS_CONFIG)) {
            return null;
        }
        JsonObject processConfig = this.json.getAsJsonObject(PROCESS_CONFIG);
        if (!processConfig.has(ENTRY_POINT)) {
            return null;
        }
        return processConfig.get(ENTRY_POINT).getAsString();
    }

    public String[] getArguments() {
        if (!this.json.has(PROCESS_CONFIG)) {
            return null;
        }
        JsonObject processConfig = this.json.getAsJsonObject(PROCESS_CONFIG);
        if (!processConfig.has(ARGUMENTS)) {
            return null;
        }
        JsonArray arguments = processConfig.getAsJsonArray(ARGUMENTS);
        String[] result = new String[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            result[i] = arguments.get(i).getAsString();
        }
        return result;
    }
}

