package io.fabric8.kubernetes.api.model.authentication.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TokenReviewBuilder extends TokenReviewFluent<TokenReviewBuilder> implements VisitableBuilder<TokenReview,TokenReviewBuilder>{
  public TokenReviewBuilder() {
    this(new TokenReview());
  }
  
  public TokenReviewBuilder(TokenReviewFluent<?> fluent) {
    this(fluent, new TokenReview());
  }
  
  public TokenReviewBuilder(TokenReviewFluent<?> fluent,TokenReview instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TokenReviewBuilder(TokenReview instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TokenReviewFluent<?> fluent;
  
  public TokenReview build() {
    TokenReview buildable = new TokenReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}