package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerResourceMetricSourceBuilder extends ContainerResourceMetricSourceFluent<ContainerResourceMetricSourceBuilder> implements VisitableBuilder<ContainerResourceMetricSource,ContainerResourceMetricSourceBuilder>{
  public ContainerResourceMetricSourceBuilder() {
    this(new ContainerResourceMetricSource());
  }
  
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent) {
    this(fluent, new ContainerResourceMetricSource());
  }
  
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,ContainerResourceMetricSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerResourceMetricSourceFluent<?> fluent;
  
  public ContainerResourceMetricSource build() {
    ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(fluent.getContainer(),fluent.getName(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}