package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MetricStatusBuilder extends MetricStatusFluent<MetricStatusBuilder> implements VisitableBuilder<MetricStatus,MetricStatusBuilder>{
  public MetricStatusBuilder() {
    this(new MetricStatus());
  }
  
  public MetricStatusBuilder(MetricStatusFluent<?> fluent) {
    this(fluent, new MetricStatus());
  }
  
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,MetricStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MetricStatusBuilder(MetricStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MetricStatusFluent<?> fluent;
  
  public MetricStatus build() {
    MetricStatus buildable = new MetricStatus(fluent.buildContainerResource(),fluent.buildExternal(),fluent.buildObject(),fluent.buildPods(),fluent.buildResource(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}