package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetricStatusFluent<A extends MetricStatusFluent<A>> extends BaseFluent<A>{
  public MetricStatusFluent() {
  }
  
  public MetricStatusFluent(MetricStatus instance) {
    this.copyInstance(instance);
  }
  private ContainerResourceMetricStatusBuilder containerResource;
  private ExternalMetricStatusBuilder external;
  private ObjectMetricStatusBuilder object;
  private PodsMetricStatusBuilder pods;
  private ResourceMetricStatusBuilder resource;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MetricStatus instance) {
    instance = (instance != null ? instance : new MetricStatus());
    if (instance != null) {
          this.withContainerResource(instance.getContainerResource());
          this.withExternal(instance.getExternal());
          this.withObject(instance.getObject());
          this.withPods(instance.getPods());
          this.withResource(instance.getResource());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ContainerResourceMetricStatus buildContainerResource() {
    return this.containerResource != null ? this.containerResource.build() : null;
  }
  
  public A withContainerResource(ContainerResourceMetricStatus containerResource) {
    this._visitables.remove("containerResource");
    if (containerResource != null) {
        this.containerResource = new ContainerResourceMetricStatusBuilder(containerResource);
        this._visitables.get("containerResource").add(this.containerResource);
    } else {
        this.containerResource = null;
        this._visitables.get("containerResource").remove(this.containerResource);
    }
    return (A) this;
  }
  
  public boolean hasContainerResource() {
    return this.containerResource != null;
  }
  
  public ContainerResourceNested<A> withNewContainerResource() {
    return new ContainerResourceNested(null);
  }
  
  public ContainerResourceNested<A> withNewContainerResourceLike(ContainerResourceMetricStatus item) {
    return new ContainerResourceNested(item);
  }
  
  public ContainerResourceNested<A> editContainerResource() {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(null));
  }
  
  public ContainerResourceNested<A> editOrNewContainerResource() {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(new ContainerResourceMetricStatusBuilder().build()));
  }
  
  public ContainerResourceNested<A> editOrNewContainerResourceLike(ContainerResourceMetricStatus item) {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(item));
  }
  
  public ExternalMetricStatus buildExternal() {
    return this.external != null ? this.external.build() : null;
  }
  
  public A withExternal(ExternalMetricStatus external) {
    this._visitables.remove("external");
    if (external != null) {
        this.external = new ExternalMetricStatusBuilder(external);
        this._visitables.get("external").add(this.external);
    } else {
        this.external = null;
        this._visitables.get("external").remove(this.external);
    }
    return (A) this;
  }
  
  public boolean hasExternal() {
    return this.external != null;
  }
  
  public ExternalNested<A> withNewExternal() {
    return new ExternalNested(null);
  }
  
  public ExternalNested<A> withNewExternalLike(ExternalMetricStatus item) {
    return new ExternalNested(item);
  }
  
  public ExternalNested<A> editExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(null));
  }
  
  public ExternalNested<A> editOrNewExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(new ExternalMetricStatusBuilder().build()));
  }
  
  public ExternalNested<A> editOrNewExternalLike(ExternalMetricStatus item) {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(item));
  }
  
  public ObjectMetricStatus buildObject() {
    return this.object != null ? this.object.build() : null;
  }
  
  public A withObject(ObjectMetricStatus object) {
    this._visitables.remove("object");
    if (object != null) {
        this.object = new ObjectMetricStatusBuilder(object);
        this._visitables.get("object").add(this.object);
    } else {
        this.object = null;
        this._visitables.get("object").remove(this.object);
    }
    return (A) this;
  }
  
  public boolean hasObject() {
    return this.object != null;
  }
  
  public ObjectNested<A> withNewObject() {
    return new ObjectNested(null);
  }
  
  public ObjectNested<A> withNewObjectLike(ObjectMetricStatus item) {
    return new ObjectNested(item);
  }
  
  public ObjectNested<A> editObject() {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(null));
  }
  
  public ObjectNested<A> editOrNewObject() {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(new ObjectMetricStatusBuilder().build()));
  }
  
  public ObjectNested<A> editOrNewObjectLike(ObjectMetricStatus item) {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(item));
  }
  
  public PodsMetricStatus buildPods() {
    return this.pods != null ? this.pods.build() : null;
  }
  
  public A withPods(PodsMetricStatus pods) {
    this._visitables.remove("pods");
    if (pods != null) {
        this.pods = new PodsMetricStatusBuilder(pods);
        this._visitables.get("pods").add(this.pods);
    } else {
        this.pods = null;
        this._visitables.get("pods").remove(this.pods);
    }
    return (A) this;
  }
  
  public boolean hasPods() {
    return this.pods != null;
  }
  
  public PodsNested<A> withNewPods() {
    return new PodsNested(null);
  }
  
  public PodsNested<A> withNewPodsLike(PodsMetricStatus item) {
    return new PodsNested(item);
  }
  
  public PodsNested<A> editPods() {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(null));
  }
  
  public PodsNested<A> editOrNewPods() {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(new PodsMetricStatusBuilder().build()));
  }
  
  public PodsNested<A> editOrNewPodsLike(PodsMetricStatus item) {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(item));
  }
  
  public ResourceMetricStatus buildResource() {
    return this.resource != null ? this.resource.build() : null;
  }
  
  public A withResource(ResourceMetricStatus resource) {
    this._visitables.remove("resource");
    if (resource != null) {
        this.resource = new ResourceMetricStatusBuilder(resource);
        this._visitables.get("resource").add(this.resource);
    } else {
        this.resource = null;
        this._visitables.get("resource").remove(this.resource);
    }
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public ResourceNested<A> withNewResource() {
    return new ResourceNested(null);
  }
  
  public ResourceNested<A> withNewResourceLike(ResourceMetricStatus item) {
    return new ResourceNested(item);
  }
  
  public ResourceNested<A> editResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(null));
  }
  
  public ResourceNested<A> editOrNewResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(new ResourceMetricStatusBuilder().build()));
  }
  
  public ResourceNested<A> editOrNewResourceLike(ResourceMetricStatus item) {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetricStatusFluent that = (MetricStatusFluent) o;
    if (!java.util.Objects.equals(containerResource, that.containerResource)) return false;
    if (!java.util.Objects.equals(external, that.external)) return false;
    if (!java.util.Objects.equals(object, that.object)) return false;
    if (!java.util.Objects.equals(pods, that.pods)) return false;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerResource,  external,  object,  pods,  resource,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerResource != null) { sb.append("containerResource:"); sb.append(containerResource + ","); }
    if (external != null) { sb.append("external:"); sb.append(external + ","); }
    if (object != null) { sb.append("object:"); sb.append(object + ","); }
    if (pods != null) { sb.append("pods:"); sb.append(pods + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerResourceNested<N> extends ContainerResourceMetricStatusFluent<ContainerResourceNested<N>> implements Nested<N>{
    ContainerResourceNested(ContainerResourceMetricStatus item) {
      this.builder = new ContainerResourceMetricStatusBuilder(this, item);
    }
    ContainerResourceMetricStatusBuilder builder;
    
    public N and() {
      return (N) MetricStatusFluent.this.withContainerResource(builder.build());
    }
    
    public N endContainerResource() {
      return and();
    }
    
  
  }
  public class ExternalNested<N> extends ExternalMetricStatusFluent<ExternalNested<N>> implements Nested<N>{
    ExternalNested(ExternalMetricStatus item) {
      this.builder = new ExternalMetricStatusBuilder(this, item);
    }
    ExternalMetricStatusBuilder builder;
    
    public N and() {
      return (N) MetricStatusFluent.this.withExternal(builder.build());
    }
    
    public N endExternal() {
      return and();
    }
    
  
  }
  public class ObjectNested<N> extends ObjectMetricStatusFluent<ObjectNested<N>> implements Nested<N>{
    ObjectNested(ObjectMetricStatus item) {
      this.builder = new ObjectMetricStatusBuilder(this, item);
    }
    ObjectMetricStatusBuilder builder;
    
    public N and() {
      return (N) MetricStatusFluent.this.withObject(builder.build());
    }
    
    public N endObject() {
      return and();
    }
    
  
  }
  public class PodsNested<N> extends PodsMetricStatusFluent<PodsNested<N>> implements Nested<N>{
    PodsNested(PodsMetricStatus item) {
      this.builder = new PodsMetricStatusBuilder(this, item);
    }
    PodsMetricStatusBuilder builder;
    
    public N and() {
      return (N) MetricStatusFluent.this.withPods(builder.build());
    }
    
    public N endPods() {
      return and();
    }
    
  
  }
  public class ResourceNested<N> extends ResourceMetricStatusFluent<ResourceNested<N>> implements Nested<N>{
    ResourceNested(ResourceMetricStatus item) {
      this.builder = new ResourceMetricStatusBuilder(this, item);
    }
    ResourceMetricStatusBuilder builder;
    
    public N and() {
      return (N) MetricStatusFluent.this.withResource(builder.build());
    }
    
    public N endResource() {
      return and();
    }
    
  
  }

}