package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentSpecBuilder extends DeploymentSpecFluent<DeploymentSpecBuilder> implements VisitableBuilder<DeploymentSpec,DeploymentSpecBuilder>{
  public DeploymentSpecBuilder() {
    this(new DeploymentSpec());
  }
  
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
    this(fluent, new DeploymentSpec());
  }
  
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent,DeploymentSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentSpecBuilder(DeploymentSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentSpecFluent<?> fluent;
  
  public DeploymentSpec build() {
    DeploymentSpec buildable = new DeploymentSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getProgressDeadlineSeconds(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.buildRollbackTo(),fluent.buildSelector(),fluent.buildStrategy(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}