package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceClaimTemplateBuilder extends ResourceClaimTemplateFluent<ResourceClaimTemplateBuilder> implements VisitableBuilder<ResourceClaimTemplate,ResourceClaimTemplateBuilder>{
  public ResourceClaimTemplateBuilder() {
    this(new ResourceClaimTemplate());
  }
  
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent) {
    this(fluent, new ResourceClaimTemplate());
  }
  
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent,ResourceClaimTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceClaimTemplateBuilder(ResourceClaimTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceClaimTemplateFluent<?> fluent;
  
  public ResourceClaimTemplate build() {
    ResourceClaimTemplate buildable = new ResourceClaimTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}