/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.NamedRoleFluent;
import io.fabric8.openshift.api.model.NamedRoleFluentImpl;
import javax.validation.Validator;

public class NamedRoleBuilder
extends NamedRoleFluentImpl<NamedRoleBuilder>
implements VisitableBuilder<NamedRole, NamedRoleBuilder> {
    NamedRoleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamedRoleBuilder() {
        this(true);
    }

    public NamedRoleBuilder(Boolean validationEnabled) {
        this(new NamedRole(), validationEnabled);
    }

    public NamedRoleBuilder(NamedRoleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamedRoleBuilder(NamedRoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedRole(), validationEnabled);
    }

    public NamedRoleBuilder(NamedRoleFluent<?> fluent, NamedRole instance) {
        this(fluent, instance, true);
    }

    public NamedRoleBuilder(NamedRoleFluent<?> fluent, NamedRole instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withRole(instance.getRole());
        this.validationEnabled = validationEnabled;
    }

    public NamedRoleBuilder(NamedRole instance) {
        this(instance, (Boolean)true);
    }

    public NamedRoleBuilder(NamedRole instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withRole(instance.getRole());
        this.validationEnabled = validationEnabled;
    }

    public NamedRoleBuilder(Validator validator) {
        this(new NamedRole(), (Boolean)true);
    }

    public NamedRoleBuilder(NamedRoleFluent<?> fluent, NamedRole instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withRole(instance.getRole());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NamedRoleBuilder(NamedRole instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withRole(instance.getRole());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NamedRole build() {
        NamedRole buildable = new NamedRole(this.fluent.getName(), this.fluent.getRole());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleBuilder that = (NamedRoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

