package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SelfSubjectAccessReviewSpecBuilder extends SelfSubjectAccessReviewSpecFluentImpl<SelfSubjectAccessReviewSpecBuilder> implements VisitableBuilder<SelfSubjectAccessReviewSpec,SelfSubjectAccessReviewSpecBuilder>{

    SelfSubjectAccessReviewSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SelfSubjectAccessReviewSpecBuilder(){
            this(true);
    }
    public SelfSubjectAccessReviewSpecBuilder(Boolean validationEnabled){
            this(new SelfSubjectAccessReviewSpec(), validationEnabled);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SelfSubjectAccessReviewSpec(), validationEnabled);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpecFluent<?> fluent,SelfSubjectAccessReviewSpec instance){
            this(fluent, instance, true);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpecFluent<?> fluent,SelfSubjectAccessReviewSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNonResourceAttributes(instance.getNonResourceAttributes()); 
            fluent.withResourceAttributes(instance.getResourceAttributes()); 
            this.validationEnabled = validationEnabled; 
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpec instance){
            this(instance,true);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNonResourceAttributes(instance.getNonResourceAttributes()); 
            this.withResourceAttributes(instance.getResourceAttributes()); 
            this.validationEnabled = validationEnabled; 
    }
    public SelfSubjectAccessReviewSpecBuilder(Validator validator){
            this(new SelfSubjectAccessReviewSpec(), true);
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpecFluent<?> fluent,SelfSubjectAccessReviewSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNonResourceAttributes(instance.getNonResourceAttributes()); 
            fluent.withResourceAttributes(instance.getResourceAttributes()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SelfSubjectAccessReviewSpecBuilder(SelfSubjectAccessReviewSpec instance,Validator validator){
            this.fluent = this; 
            this.withNonResourceAttributes(instance.getNonResourceAttributes()); 
            this.withResourceAttributes(instance.getResourceAttributes()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SelfSubjectAccessReviewSpec build(){
            SelfSubjectAccessReviewSpec buildable = new SelfSubjectAccessReviewSpec(fluent.getNonResourceAttributes(),fluent.getResourceAttributes());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SelfSubjectAccessReviewSpecBuilder that = (SelfSubjectAccessReviewSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
