/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class GroupFluentImpl<A extends GroupFluent<A>>
extends BaseFluent<A>
implements GroupFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> users = new ArrayList<String>();

    public GroupFluentImpl() {
    }

    public GroupFluentImpl(Group instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withUsers(instance.getUsers());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public GroupFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public GroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public GroupFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public GroupFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public GroupFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(int index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsers(List<String> users) {
        if (this.users != null) {
            this._visitables.get((Object)"users").removeAll(this.users);
        }
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public A addNewUser(String arg1) {
        return this.addToUsers(new String(arg1));
    }

    @Override
    public A addNewUser(StringBuilder arg1) {
        return this.addToUsers(new String(arg1));
    }

    @Override
    public A addNewUser(StringBuffer arg1) {
        return this.addToUsers(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupFluentImpl that = (GroupFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.users != null ? !this.users.equals(that.users) : that.users != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.users, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<GroupFluent.MetadataNested<N>>
    implements GroupFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)GroupFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

