/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    DriverManagerType driverManagerType;
    HttpClient httpClient;
    Config config;

    public Downloader(DriverManagerType driverManagerType) {
        this.driverManagerType = driverManagerType;
        WebDriverManager webDriverManager = WebDriverManager.getInstance(driverManagerType);
        this.config = webDriverManager.config();
        this.httpClient = webDriverManager.getHttpClient();
    }

    public synchronized String download(URL url, String version, String driverName) throws IOException, InterruptedException {
        File targetFile = this.getTarget(version, url);
        Optional<File> binary = this.checkBinary(driverName, targetFile);
        if (!binary.isPresent()) {
            binary = this.downloadAndExtract(url, targetFile);
        }
        return binary.get().toString();
    }

    public File getTarget(String version, URL url) {
        this.log.trace("getTarget {} {}", (Object)version, (Object)url);
        String zip = url.getFile().substring(url.getFile().lastIndexOf(47));
        int iFirst = zip.indexOf(95);
        int iSecond = zip.indexOf(45);
        int iLast = zip.length();
        if (iFirst != zip.lastIndexOf(95)) {
            iLast = zip.lastIndexOf(95);
        } else if (iSecond != -1) {
            iLast = iSecond;
        }
        String folder = zip.substring(0, iLast).replace(".zip", "").replace(".tar.bz2", "").replace(".tar.gz", "").replace(".msi", "").replace(".exe", "").replace("_", File.separator);
        String path = this.config.isAvoidOutputTree() ? this.getTargetPath() + zip : this.getTargetPath() + folder + File.separator + version + zip;
        String target = WebDriverManager.getInstance(this.driverManagerType).preDownload(path, version);
        this.log.trace("Target file for URL {} version {} = {}", new Object[]{url, version, target});
        return new File(target);
    }

    public String getTargetPath() {
        String targetPath = this.config.getTargetPath();
        this.log.trace("Target path {}", (Object)targetPath);
        File repository = new File(targetPath);
        if (!repository.exists()) {
            repository.mkdirs();
        }
        return targetPath;
    }

    private Optional<File> downloadAndExtract(URL url, File targetFile) throws IOException, InterruptedException {
        this.log.info("Downloading {}", (Object)url);
        File targetFolder = targetFile.getParentFile();
        File tempDir = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        File temporaryFile = new File(tempDir, targetFile.getName());
        this.log.trace("Target folder {} ... using temporal file {}", (Object)targetFolder, (Object)temporaryFile);
        FileUtils.copyInputStreamToFile((InputStream)this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(url)).getEntity().getContent(), (File)temporaryFile);
        File extractedFile = this.extract(temporaryFile);
        File resultingBinary = new File(targetFolder, extractedFile.getName());
        boolean binaryExists = resultingBinary.exists();
        if (!binaryExists || this.config.isOverride()) {
            if (binaryExists) {
                this.log.info("Overriding former binary {}", (Object)resultingBinary);
                this.deleteFile(resultingBinary);
            }
            FileUtils.moveFileToDirectory((File)extractedFile, (File)targetFolder, (boolean)true);
        }
        if (!this.config.isExecutable(resultingBinary)) {
            this.setFileExecutable(resultingBinary);
        }
        this.deleteFolder(tempDir);
        this.log.trace("Binary driver after extraction {}", (Object)resultingBinary);
        return Optional.of(resultingBinary);
    }

    private Optional<File> checkBinary(String driverName, File targetFile) {
        File parentFolder = targetFile.getParentFile();
        if (parentFolder.exists() && !this.config.isOverride()) {
            Collection listFiles = FileUtils.listFiles((File)parentFolder, null, (boolean)true);
            for (File file : listFiles) {
                if (!file.getName().startsWith(driverName) || !this.config.isExecutable(file)) continue;
                this.log.info("Using binary driver previously downloaded");
                return Optional.of(file);
            }
            this.log.trace("{} does not exist in cache", (Object)driverName);
        }
        return Optional.empty();
    }

    private File extract(File compressedFile) throws IOException, InterruptedException {
        boolean extractFile;
        String fileName = compressedFile.getName().toLowerCase();
        boolean bl = extractFile = !fileName.endsWith("exe") && !fileName.endsWith("jar");
        if (extractFile) {
            this.log.info("Extracting binary from compressed file {}", (Object)fileName);
        }
        if (fileName.endsWith("tar.bz2")) {
            this.unBZip2(compressedFile);
        } else if (fileName.endsWith("tar.gz")) {
            this.unTarGz(compressedFile);
        } else if (fileName.endsWith("gz")) {
            this.unGzip(compressedFile);
        } else if (fileName.endsWith("msi")) {
            this.extractMsi(compressedFile);
        } else if (fileName.endsWith("zip")) {
            this.unZip(compressedFile);
        }
        if (extractFile) {
            this.deleteFile(compressedFile);
        }
        File result = WebDriverManager.getInstance(this.driverManagerType).postDownload(compressedFile).getAbsoluteFile();
        this.log.trace("Resulting binary file {}", (Object)result);
        return result;
    }

    private void unZip(File compressedFile) throws IOException {
        File file = null;
        try (ZipFile zipFolder = new ZipFile(compressedFile);){
            Enumeration<? extends ZipEntry> enu = zipFolder.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                long size = zipEntry.getSize();
                long compressedSize = zipEntry.getCompressedSize();
                this.log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", new Object[]{name, size, compressedSize});
                file = new File(compressedFile.getParentFile(), name);
                if (!file.exists() || this.config.isOverride()) {
                    if (name.endsWith("/")) {
                        file.mkdirs();
                        continue;
                    }
                    File parent = file.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    try (InputStream is = zipFolder.getInputStream(zipEntry);){
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    }
                    this.setFileExecutable(file);
                    continue;
                }
                this.log.debug("{} already exists", (Object)file);
            }
        }
    }

    private void unGzip(File archive) throws IOException {
        int iDot;
        this.log.trace("UnGzip {}", (Object)archive);
        String fileName = archive.getName();
        int iDash = fileName.indexOf(45);
        if (iDash != -1) {
            fileName = fileName.substring(0, iDash);
        }
        if ((iDot = fileName.indexOf(46)) != -1) {
            fileName = fileName.substring(0, iDot);
        }
        File target = new File(archive.getParentFile(), fileName);
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(archive));
             FileOutputStream out = new FileOutputStream(target);){
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
        }
        if (!target.getName().toLowerCase().contains(".exe") && target.exists()) {
            this.setFileExecutable(target);
        }
    }

    private void unTarGz(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
        archiver.extract(archive, archive.getParentFile());
        this.log.trace("unTarGz {}", (Object)archive);
    }

    private void unBZip2(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.BZIP2);
        archiver.extract(archive, archive.getParentFile());
        this.log.trace("Unbzip2 {}", (Object)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMsi(File msi) throws IOException, InterruptedException {
        File tmpMsi = new File(Files.createTempDirectory("", new FileAttribute[0]).toFile().getAbsoluteFile() + File.separator + msi.getName());
        Files.move(msi.toPath(), tmpMsi.toPath(), new CopyOption[0]);
        this.log.trace("Temporal msi file: {}", (Object)tmpMsi);
        Process process = Runtime.getRuntime().exec(new String[]{"msiexec", "/a", tmpMsi.toString(), "/qb", "TARGETDIR=" + msi.getParent()});
        try {
            process.waitFor();
        }
        finally {
            process.destroy();
        }
        this.deleteFolder(tmpMsi.getParentFile());
    }

    protected void setFileExecutable(File file) {
        this.log.trace("Setting file {} as executable", (Object)file);
        if (!file.setExecutable(true)) {
            this.log.warn("Error setting file {} as executable", (Object)file);
        }
    }

    protected void renameFile(File from, File to) {
        this.log.trace("Renaming file from {} to {}", (Object)from, (Object)to);
        if (to.exists()) {
            this.deleteFile(to);
        }
        if (!from.renameTo(to)) {
            this.log.warn("Error renaming file from {} to {}", (Object)from, (Object)to);
        }
    }

    protected void deleteFile(File file) {
        this.log.trace("Deleting file {}", (Object)file);
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    protected void deleteFolder(File folder) {
        assert (folder.isDirectory());
        this.log.trace("Deleting folder {}", (Object)folder);
        try {
            FileUtils.deleteDirectory((File)folder);
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }
}

