/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.channel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.burukeyou.uniapi.exception.BaseUniApiException;
import com.burukeyou.uniapi.http.annotation.HttpApi;
import com.burukeyou.uniapi.http.annotation.param.BodyBinaryPar;
import com.burukeyou.uniapi.http.annotation.param.BodyFormPar;
import com.burukeyou.uniapi.http.annotation.param.BodyJsonPar;
import com.burukeyou.uniapi.http.annotation.param.BodyMultiPartPar;
import com.burukeyou.uniapi.http.annotation.param.ComposePar;
import com.burukeyou.uniapi.http.annotation.param.CookiePar;
import com.burukeyou.uniapi.http.annotation.param.HeaderPar;
import com.burukeyou.uniapi.http.annotation.param.PathPar;
import com.burukeyou.uniapi.http.annotation.param.QueryPar;
import com.burukeyou.uniapi.http.annotation.request.HttpInterface;
import com.burukeyou.uniapi.http.core.channel.HttpMetadataFinder;
import com.burukeyou.uniapi.http.core.request.HttpBody;
import com.burukeyou.uniapi.http.core.request.HttpBodyBinary;
import com.burukeyou.uniapi.http.core.request.HttpBodyFormData;
import com.burukeyou.uniapi.http.core.request.HttpBodyJSON;
import com.burukeyou.uniapi.http.core.request.HttpBodyMultipart;
import com.burukeyou.uniapi.http.core.request.HttpMetadata;
import com.burukeyou.uniapi.http.core.request.HttpUrl;
import com.burukeyou.uniapi.http.core.request.MultipartDataItem;
import com.burukeyou.uniapi.http.support.Cookie;
import com.burukeyou.uniapi.support.arg.ArgList;
import com.burukeyou.uniapi.support.arg.ClassFieldArgList;
import com.burukeyou.uniapi.support.arg.MapArgList;
import com.burukeyou.uniapi.support.arg.MethodArgList;
import com.burukeyou.uniapi.support.arg.Param;
import com.burukeyou.uniapi.util.ListsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.CollectionUtils;

public abstract class AbstractHttpMetadataParamFinder
implements HttpMetadataFinder {
    protected HttpApi api;
    protected HttpInterface httpInterface;
    protected Environment environment;
    protected MethodInvocation methodInvocation;

    public AbstractHttpMetadataParamFinder(HttpApi api, HttpInterface httpInterface, Environment environment) {
        this.api = api;
        this.httpInterface = httpInterface;
        this.environment = environment;
    }

    @Override
    public HttpMetadata find(Method method, Object[] args) {
        Object httpUrl = ((HttpUrl.HttpUrlBuilder)HttpUrl.builder().path(this.httpInterface.path())).build();
        if (StringUtils.isNotBlank((CharSequence)this.httpInterface.url())) {
            ((HttpUrl)httpUrl).setUrl(this.getEnvironmentValue(this.httpInterface.url()));
        } else {
            ((HttpUrl)httpUrl).setUrl(this.getEnvironmentValue(this.api.url()));
        }
        HttpMetadata httpMetadata = new HttpMetadata();
        httpMetadata.setRequestMethod(this.httpInterface.method());
        httpMetadata.setHttpUrl((HttpUrl)httpUrl);
        MethodArgList argList = new MethodArgList(method, args);
        this.fillHttpMetadata(httpMetadata, (ArgList)argList);
        this.parseCombineParam(httpMetadata, (ArgList)argList);
        return httpMetadata;
    }

    public <T> T getEnvironmentValue(T value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() != String.class) {
            return value;
        }
        return (T)this.environment.resolvePlaceholders(value.toString());
    }

    private List<Cookie> findCookies(ArgList argList) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(this.parseCookie(this.getEnvironmentValue(this.httpInterface.cookie())));
        for (Param param : argList) {
            CookiePar annotation;
            Object argValue = param.getValue();
            if (argValue == null || (annotation = (CookiePar)param.getAnnotation(CookiePar.class)) == null) continue;
            if (argValue instanceof Cookie) {
                cookies.add((Cookie)argValue);
                continue;
            }
            if (param.isCollection(Cookie.class)) {
                List tmp = param.castListValue(Cookie.class);
                if (CollectionUtils.isEmpty((Collection)tmp)) continue;
                cookies.addAll(tmp);
                continue;
            }
            if (Map.class.equals((Object)param.getType())) {
                List tmpList = ((Map)argValue).entrySet().stream().map(e -> new Cookie(e.getKey().toString(), e.getValue().toString())).collect(Collectors.toList());
                cookies.addAll(tmpList);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)annotation.value()) && String.class.equals((Object)param.getType())) {
                cookies.add(new Cookie(annotation.value(), argValue.toString()));
                continue;
            }
            if (String.class.equals((Object)param.getType())) {
                cookies.addAll(this.parseCookie(argValue.toString()));
                continue;
            }
            if (!param.isCollection(String.class)) continue;
            for (String cookieStr : param.castListValue(String.class)) {
                cookies.addAll(this.parseCookie(cookieStr));
            }
        }
        return cookies;
    }

    public List<Cookie> parseCookie(String cookie) {
        if (StringUtils.isBlank((CharSequence)cookie)) {
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (String item : cookie.split(";")) {
            String[] split = item.split("=");
            cookieList.add(new Cookie(split[0].trim(), split[1].trim()));
        }
        return cookieList;
    }

    public HttpMetadata find(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Object[] args = methodInvocation.getArguments();
        return this.find(method, args);
    }

    @Override
    public Map<String, Object> findQueryParam(Method method, Object[] args) {
        return this.findQueryParam((ArgList)new MethodArgList(method, args));
    }

    @Override
    public Map<String, String> findPathParam(Method method, Object[] args) {
        return this.findPathParam((ArgList)new MethodArgList(method, args));
    }

    @Override
    public Map<String, String> findHeaders(Method method, Object[] args) {
        return this.findHeaders((ArgList)new MethodArgList(method, args));
    }

    @Override
    public HttpBody findHttpBody(Method method, Object[] args) {
        return this.findHttpBody((ArgList)new MethodArgList(method, args));
    }

    public HttpBody findHttpBody(ArgList argList) {
        for (Param methodArg : argList) {
            BodyMultiPartPar multipartParam;
            if (methodArg.getValue() == null) continue;
            Object argValue = methodArg.getValue();
            BodyJsonPar annotation = (BodyJsonPar)methodArg.getAnnotation(BodyJsonPar.class);
            if (annotation != null) {
                return new HttpBodyJSON(this.getArgFillValue(argValue).toString());
            }
            BodyBinaryPar binaryParam = (BodyBinaryPar)methodArg.getAnnotation(BodyBinaryPar.class);
            if (binaryParam != null) {
                return this.getHttpBodyBinaryForValue(argValue);
            }
            BodyFormPar stringFormParam = (BodyFormPar)methodArg.getAnnotation(BodyFormPar.class);
            if (stringFormParam != null) {
                if (this.isObjOrMap(argValue.getClass())) {
                    return new HttpBodyFormData(this.objToMap(argValue));
                }
                if (!methodArg.isCollection()) {
                    if (StringUtils.isBlank((CharSequence)stringFormParam.value())) {
                        throw new BaseUniApiException("user @BodyFormPar for single value please specify the parameter name ");
                    }
                    return new HttpBodyFormData(Collections.singletonMap(stringFormParam.value(), this.getArgFillValue(argValue).toString()));
                }
            }
            if ((multipartParam = (BodyMultiPartPar)methodArg.getAnnotation(BodyMultiPartPar.class)) == null) continue;
            boolean nameExistFlag = StringUtils.isNotBlank((CharSequence)multipartParam.value());
            if (nameExistFlag && File.class.isAssignableFrom(methodArg.getType())) {
                MultipartDataItem dataItem = new MultipartDataItem(multipartParam.value(), null, (File)argValue, true);
                return new HttpBodyMultipart(Collections.singletonList(dataItem));
            }
            if (this.isObjOrMap(methodArg.getType())) {
                return this.getHttpBodyMultipartFormData(argValue, methodArg.getType());
            }
            if (!nameExistFlag) continue;
            MultipartDataItem dataItem = new MultipartDataItem(multipartParam.value(), argValue.toString(), null, false);
            return new HttpBodyMultipart(Collections.singletonList(dataItem));
        }
        return null;
    }

    private HttpBodyMultipart getHttpBodyMultipartFormData(Object argValue, Class<?> argClass) {
        ArrayList<MultipartDataItem> dataItems = new ArrayList<MultipartDataItem>();
        ArgList argList = this.autoGetArgList(argValue);
        for (Param param : argList) {
            boolean isFile;
            Object fieldValue = param.getValue();
            JSONField jsonField = (JSONField)param.getAnnotation(JSONField.class);
            com.alibaba.fastjson2.annotation.JSONField jsonField2 = (com.alibaba.fastjson2.annotation.JSONField)param.getAnnotation(com.alibaba.fastjson2.annotation.JSONField.class);
            String fieldName = param.getName();
            if (jsonField != null) {
                fieldName = jsonField.name();
            }
            if (jsonField2 != null) {
                fieldName = jsonField2.name();
            }
            if (!(isFile = this.isFileField(param)) && this.isObjOrMap(param.getType())) continue;
            if (!isFile) {
                String fieldValueStr = fieldValue == null ? null : fieldValue.toString();
                dataItems.add(new MultipartDataItem(fieldName, fieldValueStr, null, false));
                continue;
            }
            if (!param.getType().isArray() && !Collection.class.isAssignableFrom(param.getType())) {
                File onefile = fieldValue == null ? null : (File)fieldValue;
                dataItems.add(new MultipartDataItem(fieldName, null, onefile, true));
                continue;
            }
            if (fieldValue == null) {
                dataItems.add(new MultipartDataItem(fieldName, null, null, true));
                continue;
            }
            File[] fileArr = null;
            fileArr = Collection.class.isAssignableFrom(param.getType()) ? ((Collection)fieldValue).toArray(new File[0]) : (File[])fieldValue;
            for (File file : fileArr) {
                dataItems.add(new MultipartDataItem(fieldName, null, file, true));
            }
        }
        return new HttpBodyMultipart(dataItems);
    }

    private boolean isFileField(Param param) {
        Class clz = param.getType();
        if (File.class.isAssignableFrom(clz)) {
            return true;
        }
        return param.isCollection(File.class);
    }

    private Map<String, String> objToMap(Object argValue) {
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)argValue), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
    }

    private HttpBodyBinary getHttpBodyBinaryForValue(Object argValue) {
        InputStream inputStream = this.getInputStream(argValue);
        return new HttpBodyBinary(inputStream);
    }

    private InputStream getInputStream(Object argValue) {
        InputStream inputStream = null;
        try {
            if (argValue instanceof InputStream) {
                inputStream = (InputStream)argValue;
            } else if (argValue instanceof File) {
                inputStream = Files.newInputStream(((File)argValue).toPath(), new OpenOption[0]);
            } else if (argValue instanceof InputStreamSource) {
                inputStream = ((InputStreamSource)argValue).getInputStream();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return inputStream;
    }

    public Map<String, String> findHeaders(ArgList argList) {
        String[] headers = this.httpInterface.headers();
        Map<String, String> fixHeaders = Arrays.stream(headers).filter(e -> e.contains("=") || e.contains(":")).collect(Collectors.toMap(e -> e.split("[=:]")[0].trim(), e -> e.split("[=:]")[1].trim()));
        for (Param methodArg : argList) {
            HeaderPar annotation = (HeaderPar)methodArg.getAnnotation(HeaderPar.class);
            if (annotation == null || methodArg.isCollection()) continue;
            Object argValue = methodArg.getValue();
            String tmpFiledName = StringUtils.isNotBlank((CharSequence)annotation.value()) ? annotation.value() : methodArg.getName();
            boolean isObjFlag = this.isObjOrMap(methodArg.getType());
            if (StringUtils.isBlank((CharSequence)tmpFiledName) && !isObjFlag) {
                throw new IllegalArgumentException("use @HeaderPar please specify parameter name");
            }
            Object value = this.getActualArgValue(argValue);
            if (value == null) {
                if (isObjFlag) continue;
                fixHeaders.put(tmpFiledName, null);
                continue;
            }
            if (!isObjFlag) {
                fixHeaders.put(tmpFiledName, this.getArgFillValue(argValue).toString());
                continue;
            }
            fixHeaders.putAll(this.getHeaderParamForObj(value));
        }
        return fixHeaders;
    }

    public Map<String, String> getHeaderParamForObj(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Param param : this.autoGetArgList(obj)) {
            HeaderPar annotation;
            Object fieldValue = this.getArgFillValue(param.getValue());
            String fileName = param.getName();
            if (fieldValue != null && this.isObjOrMap(param.getType())) {
                fieldValue = null;
            }
            if ((annotation = (HeaderPar)param.getAnnotation(HeaderPar.class)) != null) {
                fileName = StringUtils.isNotBlank((CharSequence)annotation.value()) ? annotation.value() : fileName;
            }
            map.put(fileName, fieldValue == null ? null : fieldValue.toString());
        }
        return map;
    }

    public Map<String, Object> findQueryParam(ArgList argList) {
        String[] params = this.httpInterface.params();
        Map<String, String> queryParam = Arrays.stream(params).filter(e -> e.contains("=") || e.contains(":")).collect(Collectors.toMap(e -> e.split("[=:]")[0], e -> e.split("[=:]")[1]));
        String paramStr = this.httpInterface.paramStr();
        if (StringUtils.isNotBlank((CharSequence)paramStr) && paramStr.contains("=")) {
            for (String item : paramStr.split("[&;\uff1b]")) {
                String[] itemArr = item.split("=");
                queryParam.put(itemArr[0], itemArr[1]);
            }
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>(queryParam);
        for (Param param : argList) {
            QueryPar annotation = (QueryPar)param.getAnnotation(QueryPar.class);
            if (annotation == null) continue;
            String tmpFiledName = StringUtils.isNotBlank((CharSequence)annotation.value()) ? annotation.value() : param.getName();
            boolean needFlag = this.isObjOrMap(param.getType());
            if ((!needFlag || param.isCollection()) && StringUtils.isBlank((CharSequence)tmpFiledName)) {
                throw new IllegalArgumentException("use @QueryPar please specify parameter name");
            }
            Object argValue = param.getValue();
            Object value = this.getActualArgValue(argValue);
            if (value == null) {
                if (needFlag) continue;
                queryMap.put(tmpFiledName, null);
                continue;
            }
            if (!needFlag) {
                if (param.isCollection()) {
                    value = param.castListValue(Object.class).stream().map(Object::toString).filter(Objects::nonNull).collect(Collectors.joining(","));
                }
                queryMap.put(tmpFiledName, value);
                continue;
            }
            queryMap.putAll(this.getQueryParamForObj(value));
        }
        return queryMap;
    }

    public Map<String, String> findPathParam(ArgList argList) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        for (Param methodArg : argList) {
            PathPar annotation = (PathPar)methodArg.getAnnotation(PathPar.class);
            if (annotation == null || !methodArg.isNormalValue()) continue;
            String tmpFiledName = annotation.value();
            Object value = this.getActualArgValue(methodArg.getValue());
            if (value == null) {
                queryMap.put(tmpFiledName, null);
                continue;
            }
            queryMap.put(tmpFiledName, value.toString());
        }
        return queryMap;
    }

    public ArgList autoGetArgList(Object obj) {
        if (obj == null) {
            return ListsUtil.emptyArgList();
        }
        if (!this.isObjOrMap(obj.getClass())) {
            return ListsUtil.emptyArgList();
        }
        Object argList = Map.class.isAssignableFrom(obj.getClass()) ? new MapArgList((Map)obj) : new ClassFieldArgList(obj);
        return argList;
    }

    public Map<String, Object> getQueryParamForObj(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Param param : this.autoGetArgList(obj)) {
            QueryPar annotation;
            Object fieldValue = this.getArgFillValue(param.getValue());
            String fileName = param.getName();
            if (fieldValue != null && this.isObjOrMap(param.getType())) {
                fieldValue = null;
            }
            if ((annotation = (QueryPar)param.getAnnotation(QueryPar.class)) != null) {
                fileName = StringUtils.isNotBlank((CharSequence)annotation.value()) ? annotation.value() : fileName;
            }
            map.put(fileName, fieldValue);
        }
        return map;
    }

    public void parseCombineParam(HttpMetadata httpMetadata, ArgList list) {
        for (Param methodArg : list) {
            ComposePar annotation;
            if (methodArg.getValue() == null || (annotation = (ComposePar)methodArg.getAnnotation(ComposePar.class)) == null || methodArg.isCollection() || !methodArg.isObject()) continue;
            this.fillHttpMetadata(httpMetadata, (ArgList)new ClassFieldArgList(methodArg.getValue()));
        }
    }

    private void fillHttpMetadata(HttpMetadata httpMetadata, ArgList paramArgList) {
        httpMetadata.putAllQueryParam(this.findQueryParam(paramArgList));
        httpMetadata.putAllPathParam(this.findPathParam(paramArgList));
        httpMetadata.setBodyIfAbsent(this.findHttpBody(paramArgList));
        httpMetadata.putAllHeaders(this.findHeaders(paramArgList));
        httpMetadata.addAllCookies(this.findCookies(paramArgList));
    }

    public boolean isEmpty(Object arg) {
        Object argValue = this.getActualArgValue(arg);
        if (argValue == null) {
            return true;
        }
        if (argValue.getClass() == String.class) {
            return StringUtils.isBlank((CharSequence)((String)argValue));
        }
        return false;
    }

    public Object getActualArgValue(Object argValue) {
        if (argValue == null) {
            return null;
        }
        Class<?> type = argValue.getClass();
        if (type.isEnum()) {
            return argValue.toString();
        }
        return argValue;
    }

    public boolean isBaseType(Class<?> valueClass) {
        if (valueClass.isPrimitive()) {
            return true;
        }
        return !this.isObjOrMap(valueClass) && !this.isObjOrArr(valueClass);
    }

    public boolean isObjOrMap(Class<?> valueClass) {
        ClassLoader classLoader = valueClass.getClassLoader();
        if (valueClass.isPrimitive() || valueClass.isEnum()) {
            return false;
        }
        if (valueClass.isArray() || List.class.isAssignableFrom(valueClass) || Collection.class.isAssignableFrom(valueClass)) {
            return false;
        }
        if (classLoader == this.getClass().getClassLoader()) {
            return true;
        }
        return Map.class.isAssignableFrom(valueClass);
    }

    public boolean isArr(Class<?> valueClass) {
        if (valueClass.isArray() || Collection.class.isAssignableFrom(valueClass)) {
            return true;
        }
        return true;
    }

    public boolean isObjOrArr(Class<?> valueClass) {
        if (this.isObjOrMap(valueClass)) {
            return true;
        }
        return valueClass.isArray() || List.class.isAssignableFrom(valueClass) || Collection.class.isAssignableFrom(valueClass);
    }

    public boolean isObjOrArrOrMap(Class<?> valueClass) {
        return this.isObjOrArr(valueClass) || this.isObjOrMap(valueClass);
    }

    public Object getArgFillValue(Object argValue) {
        Object value = this.getActualArgValue(argValue);
        if (value == null) {
            return null;
        }
        if (this.isObjOrArr(argValue.getClass()) || Map.class.isAssignableFrom(argValue.getClass())) {
            return JSON.toJSONString((Object)value);
        }
        return value;
    }

    public HttpApi getApi() {
        return this.api;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterface;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public MethodInvocation getMethodInvocation() {
        return this.methodInvocation;
    }

    public void setApi(HttpApi api) {
        this.api = api;
    }

    public void setHttpInterface(HttpInterface httpInterface) {
        this.httpInterface = httpInterface;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setMethodInvocation(MethodInvocation methodInvocation) {
        this.methodInvocation = methodInvocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHttpMetadataParamFinder)) {
            return false;
        }
        AbstractHttpMetadataParamFinder other = (AbstractHttpMetadataParamFinder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpApi this$api = this.getApi();
        HttpApi other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        HttpInterface this$httpInterface = this.getHttpInterface();
        HttpInterface other$httpInterface = other.getHttpInterface();
        if (this$httpInterface == null ? other$httpInterface != null : !this$httpInterface.equals(other$httpInterface)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        MethodInvocation this$methodInvocation = this.getMethodInvocation();
        MethodInvocation other$methodInvocation = other.getMethodInvocation();
        return !(this$methodInvocation == null ? other$methodInvocation != null : !this$methodInvocation.equals(other$methodInvocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractHttpMetadataParamFinder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpApi $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        HttpInterface $httpInterface = this.getHttpInterface();
        result = result * 59 + ($httpInterface == null ? 43 : $httpInterface.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        MethodInvocation $methodInvocation = this.getMethodInvocation();
        result = result * 59 + ($methodInvocation == null ? 43 : $methodInvocation.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractHttpMetadataParamFinder(api=" + this.getApi() + ", httpInterface=" + this.getHttpInterface() + ", environment=" + this.getEnvironment() + ", methodInvocation=" + this.getMethodInvocation() + ")";
    }
}

