/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.channel;

import com.burukeyou.uniapi.exception.BaseUniApiException;
import com.burukeyou.uniapi.http.annotation.request.HttpInterface;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class AnnotationConfigCacheInvoker {
    private final Map<Method, HttpInterface> httpInterfaceCache = new ConcurrentHashMap<Method, HttpInterface>();

    protected HttpInterface getHttpInterfaceInfo(Method method) {
        HttpInterface httpInterface = this.httpInterfaceCache.get(method);
        if (httpInterface == null) {
            httpInterface = (HttpInterface)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, HttpInterface.class);
            if (httpInterface == null) {
                throw new BaseUniApiException("please mask @HttpInterface in this method " + method.getName() + "and config http path");
            }
            this.httpInterfaceCache.put(method, httpInterface);
        }
        return httpInterface;
    }
}

