/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.channel;

import com.burukeyou.uniapi.config.SpringBeanContext;
import com.burukeyou.uniapi.http.annotation.HttpApi;
import com.burukeyou.uniapi.http.annotation.ResponseFile;
import com.burukeyou.uniapi.http.annotation.request.HttpInterface;
import com.burukeyou.uniapi.http.core.channel.AbstractHttpMetadataParamFinder;
import com.burukeyou.uniapi.http.core.channel.HttpApiMethodInvocationImpl;
import com.burukeyou.uniapi.http.core.channel.HttpSender;
import com.burukeyou.uniapi.http.core.exception.SendHttpRequestException;
import com.burukeyou.uniapi.http.core.request.HttpBody;
import com.burukeyou.uniapi.http.core.request.HttpBodyBinary;
import com.burukeyou.uniapi.http.core.request.HttpBodyFormData;
import com.burukeyou.uniapi.http.core.request.HttpBodyJSON;
import com.burukeyou.uniapi.http.core.request.HttpBodyMultipart;
import com.burukeyou.uniapi.http.core.request.HttpMetadata;
import com.burukeyou.uniapi.http.core.request.HttpUrl;
import com.burukeyou.uniapi.http.core.request.MultipartDataItem;
import com.burukeyou.uniapi.http.core.response.AbstractHttpResponse;
import com.burukeyou.uniapi.http.core.response.HttpBinaryResponse;
import com.burukeyou.uniapi.http.core.response.HttpFileResponse;
import com.burukeyou.uniapi.http.core.response.HttpInputStreamResponse;
import com.burukeyou.uniapi.http.core.response.HttpJsonResponse;
import com.burukeyou.uniapi.http.core.response.HttpResponse;
import com.burukeyou.uniapi.http.extension.EmptyHttpApiProcessor;
import com.burukeyou.uniapi.http.extension.HttpApiProcessor;
import com.burukeyou.uniapi.http.support.HttpApiAnnotationMeta;
import com.burukeyou.uniapi.http.support.MediaTypeEnum;
import com.burukeyou.uniapi.http.support.RequestMethod;
import com.burukeyou.uniapi.support.ClassUtil;
import com.burukeyou.uniapi.support.arg.MethodArgList;
import com.burukeyou.uniapi.support.arg.Param;
import com.burukeyou.uniapi.util.TimeUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.FileCopyUtils;

public class DefaultHttpApiInvoker
extends AbstractHttpMetadataParamFinder
implements HttpSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpApiInvoker.class);
    protected Class<?> targetClass;
    protected HttpApiAnnotationMeta annotationMeta;
    private static final Pattern pattern = Pattern.compile("filename\\s*=\\s*\\\"(.*)\\\"");
    private static OkHttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultHttpApiInvoker(HttpApiAnnotationMeta annotationMeta, Class<?> targetClass, HttpInterface httpInterface, MethodInvocation methodInvocation) {
        super(annotationMeta.getHttpApi(), httpInterface, annotationMeta.getProxySupport().getEnvironment());
        this.targetClass = targetClass;
        this.annotationMeta = annotationMeta;
        this.methodInvocation = methodInvocation;
        if (client != null) return;
        Class<DefaultHttpApiInvoker> clazz = DefaultHttpApiInvoker.class;
        synchronized (DefaultHttpApiInvoker.class) {
            if (client != null) return;
            client = (OkHttpClient)SpringBeanContext.getBean(OkHttpClient.class);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public Class<? extends HttpApiProcessor<?>> getHttpApiProcessor(HttpApi api, HttpInterface httpInterface) {
        if (httpInterface.processor().length > 0) {
            return httpInterface.processor()[0];
        }
        if (api.processor().length > 0) {
            return api.processor()[0];
        }
        return EmptyHttpApiProcessor.class;
    }

    public HttpApiProcessor<Annotation> buildRequestHttpApiProcessor(Class<? extends HttpApiProcessor<?>> apiProcessor) {
        HttpApiProcessor processor = (HttpApiProcessor)SpringBeanContext.getMultiBean(apiProcessor);
        if (processor != null) {
            return processor;
        }
        try {
            return apiProcessor.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Object invoke() {
        Method method = this.methodInvocation.getMethod();
        HttpMetadata httpMetadata = this.createHttpMetadata(this.methodInvocation);
        HttpApiMethodInvocationImpl param = new HttpApiMethodInvocationImpl();
        param.setProxyApiAnnotation(this.annotationMeta.getProxyAnnotation());
        param.setProxyInterface(this.httpInterface);
        param.setProxyClass(this.targetClass);
        param.setMethodInvocation(this.methodInvocation);
        Class<HttpApiProcessor<?>> apiProcessor = this.getHttpApiProcessor(this.api, this.httpInterface);
        HttpApiProcessor<Annotation> requestProcessor = this.buildRequestHttpApiProcessor(apiProcessor);
        ParameterizedType paramTypeHttpApiProcessor = ClassUtil.getSuperInterfacesParameterizedType(apiProcessor, HttpApiProcessor.class);
        if (paramTypeHttpApiProcessor == null) {
            throw new IllegalArgumentException(apiProcessor.getName() + " must be implement interface HttpApiProcessor");
        }
        Type actualTypeArgument = paramTypeHttpApiProcessor.getActualTypeArguments()[0];
        Annotation proxyAnnotation = this.annotationMeta.getProxyAnnotation();
        if (!actualTypeArgument.equals(Annotation.class) && !actualTypeArgument.equals(proxyAnnotation.annotationType())) {
            throw new IllegalArgumentException("The specified HttpApiProcessor cannot handle this annotation type " + proxyAnnotation.annotationType().getSimpleName());
        }
        HttpResponse<?> response = requestProcessor.postSendingHttpRequest(this, httpMetadata = requestProcessor.postBeforeHttpMetadata(httpMetadata, param), param);
        if (response instanceof HttpJsonResponse) {
            HttpJsonResponse jsonResponse = (HttpJsonResponse)response;
            String newJsonRsp = requestProcessor.postAfterHttpResponseBodyString(jsonResponse.getTextValue(), response, httpMetadata, param);
            jsonResponse.setTextValue(newJsonRsp);
        }
        Object result = requestProcessor.postAfterHttpResponseBodyResult(response.getBodyResult(), response, httpMetadata, param);
        ((AbstractHttpResponse)response).setBodyResult(result);
        HttpResponse<?> methodReturnValue = HttpResponse.class.isAssignableFrom(method.getReturnType()) ? response : response.getBodyResult();
        return requestProcessor.postAfterMethodReturnValue(methodReturnValue, response, httpMetadata, param);
    }

    private HttpMetadata createHttpMetadata(MethodInvocation methodInvocation) {
        return this.find(methodInvocation);
    }

    @Override
    public HttpResponse<?> sendHttpRequest(HttpMetadata httpMetadata) {
        HttpInputStreamResponse httpInputStreamResponse;
        block17: {
            String cookie;
            RequestMethod requestMethod = httpMetadata.getRequestMethod();
            HttpUrl httpUrl = httpMetadata.getHttpUrl();
            Map<String, String> oldHeaders = httpMetadata.getHeaders();
            HashMap<String, String> headers = new HashMap<String, String>();
            oldHeaders.forEach((key, value) -> {
                try {
                    headers.put((String)key, URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            });
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder = requestBuilder.url(httpUrl.toUrl());
            if (headers != null && !headers.isEmpty()) {
                Headers.Builder headerBuilder = new Headers.Builder();
                headers.forEach((arg_0, arg_1) -> ((Headers.Builder)headerBuilder).add(arg_0, arg_1));
                requestBuilder = requestBuilder.headers(headerBuilder.build());
            }
            if (StringUtils.isNotBlank((CharSequence)(cookie = httpMetadata.getCookieString()))) {
                try {
                    requestBuilder.header("Cookie", URLEncoder.encode(cookie, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            RequestBody requestBody = null;
            if (httpMetadata.getBody() != null && !httpMetadata.getBody().emptyContent()) {
                requestBody = this.convertToRequestBody(httpMetadata.getBody());
                requestBuilder = requestBuilder.post(requestBody);
            }
            if (requestBody == null && requestMethod.needBody()) {
                requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"");
            }
            requestBuilder = requestBuilder.method(httpMetadata.getRequestMethod().name(), requestBody);
            Request request = requestBuilder.build();
            Call call = client.newCall(request);
            Response response = call.execute();
            try {
                if (!response.isSuccessful()) {
                    throw new SendHttpRequestException("Http\u8bf7\u6c42\u5f02\u5e38 \u54cd\u5e94\u72b6\u6001\u7801\u3010" + response.code() + "\u3011\u7ed3\u679c:\u3010" + response.body().string() + "\u3011");
                }
                AbstractHttpResponse httpResponse = null;
                Class<?> returnType = this.methodInvocation.getMethod().getReturnType();
                httpResponse = this.isFileDownloadResponse(response) ? (File.class.isAssignableFrom(returnType) ? this.doWithHttpFileResponse(response) : (InputStream.class.isAssignableFrom(returnType) ? new HttpInputStreamResponse(response.body().byteStream(), this.getFileResponseName(response)) : this.doWithHttpBinaryResponse(response))) : new HttpJsonResponse(response.body().string(), this.methodInvocation.getMethod());
                httpResponse.setMethod(this.methodInvocation.getMethod());
                httpResponse.setRequest(request);
                httpResponse.setResponse(response);
                httpResponse.setHttpMetadata(httpMetadata);
                httpInputStreamResponse = httpResponse;
                if (response == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SendHttpRequestException("Http\u8bf7\u6c42\u7f51\u7edc\u5f02\u5e38", e);
                }
                catch (SendHttpRequestException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SendHttpRequestException("Http\u8bf7\u6c42\u5f02\u5e38", e);
                }
            }
            response.close();
        }
        return httpInputStreamResponse;
    }

    private AbstractHttpResponse<?> doWithHttpFileResponse(Response response) {
        String savePath = this.getSavePath(response);
        ResponseBody responseBody = response.body();
        InputStream inputStream = responseBody.byteStream();
        DefaultHttpApiInvoker.createDirIfNotExist(Paths.get(savePath, new String[0]).getParent().toString());
        try {
            File file = new File(savePath);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            return new HttpFileResponse(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSavePath(Response response) {
        String savePath = null;
        for (Param methodArg : new MethodArgList(this.methodInvocation.getMethod(), this.methodInvocation.getArguments())) {
            ResponseFile annotation = (ResponseFile)methodArg.getAnnotation(ResponseFile.class);
            if (annotation == null) continue;
            if (!String.class.equals((Object)methodArg.getType())) {
                throw new IllegalArgumentException("@ResponseFile use in method param must be marked on String type ");
            }
            savePath = (String)methodArg.getValue();
        }
        String fileName = this.getFileResponseName(response);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = TimeUtil.formatPure((LocalDateTime)LocalDateTime.now());
        }
        if (savePath != null) {
            if (this.isFileForPath(savePath)) {
                return savePath;
            }
            return this.joinPath(savePath, fileName);
        }
        String saveDir = "/tmp/{YYYYMMDD}/";
        saveDir = this.getEnvironmentValue(saveDir);
        ResponseFile responseFileAnno = (ResponseFile)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)this.methodInvocation.getMethod(), ResponseFile.class);
        if (responseFileAnno != null) {
            saveDir = responseFileAnno.saveDir();
        }
        if (responseFileAnno == null || responseFileAnno.uuid()) {
            saveDir = this.joinPath(saveDir, this.getUUID());
        }
        if (saveDir.contains("{YYYYMMDD}")) {
            saveDir = saveDir.replace("{YYYYMMDD}", TimeUtil.formatPure((LocalDate)LocalDate.now()));
        }
        savePath = this.joinPath(saveDir, fileName);
        return savePath;
    }

    private boolean isFileForPath(String path) {
        return Paths.get(path, new String[0]).getFileName().toString().contains(".");
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private AbstractHttpResponse<?> doWithHttpBinaryResponse(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        String fileName = this.getFileResponseName(response);
        byte[] bytes = responseBody.bytes();
        return new HttpBinaryResponse(fileName, bytes);
    }

    protected boolean isFileDownloadResponse(Response response) {
        String contentType = response.header("Content-Type");
        if (MediaTypeEnum.isFileDownLoadType(contentType)) {
            return true;
        }
        String disposition = response.header("Content-Disposition");
        return StringUtils.isNotBlank((CharSequence)disposition) && disposition.contains("attachment");
    }

    protected String getFileResponseName(Response response) {
        String header = response.header("Content-Disposition");
        if (StringUtils.isBlank((CharSequence)header)) {
            return null;
        }
        String fileName = null;
        Matcher matcher = pattern.matcher(header);
        if (matcher.find()) {
            fileName = matcher.group(1);
        }
        return fileName;
    }

    protected RequestBody convertToRequestBody(HttpBody body) {
        if (body.emptyContent()) {
            return null;
        }
        MediaType mediaTypeJson = MediaType.parse((String)body.getContentType());
        RequestBody requestBody = null;
        if (body instanceof HttpBodyJSON) {
            requestBody = RequestBody.create((MediaType)mediaTypeJson, (String)body.toStringBody());
        } else if (body instanceof HttpBodyBinary) {
            InputStream inputStream = ((HttpBodyBinary)body).getFile();
            requestBody = RequestBody.create((MediaType)mediaTypeJson, (byte[])DefaultHttpApiInvoker.streamToByteArray(inputStream));
        } else if (body instanceof HttpBodyFormData) {
            FormBody.Builder builder = new FormBody.Builder();
            HttpBodyFormData formDataBody = (HttpBodyFormData)body;
            formDataBody.getFormData().forEach((arg_0, arg_1) -> ((FormBody.Builder)builder).add(arg_0, arg_1));
            requestBody = builder.build();
        } else if (body instanceof HttpBodyMultipart) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            HttpBodyMultipart multipartFormData = (HttpBodyMultipart)body;
            for (MultipartDataItem dataItem : multipartFormData.getMultiPartData()) {
                if (!dataItem.isFileFlag()) {
                    builder.addFormDataPart(dataItem.getKey(), dataItem.getTextValue());
                    continue;
                }
                File file = dataItem.getFileValue();
                if (file == null) continue;
                RequestBody fileBody = RequestBody.create((MediaType)MultipartBody.FORM, (File)file);
                builder.addFormDataPart(dataItem.getKey(), file.getName(), fileBody);
            }
            requestBody = builder.build();
        }
        return requestBody;
    }

    public static byte[] streamToByteArray(InputStream is) {
        try {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = is.read(b)) != -1) {
                bos.write(b, 0, len);
            }
            byte[] array = bos.toByteArray();
            bos.close();
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String joinPath(Object ... paths) {
        ArrayList<String> cleanPaths = new ArrayList<String>();
        for (Object tmp : paths) {
            String path = tmp.toString();
            if (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            cleanPaths.add(path);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(File.separator);
        for (String cleanPath : cleanPaths) {
            stringBuilder.append(cleanPath).append(File.separator);
        }
        return stringBuilder.toString();
    }

    private static void createDirIfNotExist(String baseDir) {
        Path dir = Paths.get(baseDir, new String[0]);
        boolean notExists = Files.notExists(dir, new LinkOption[0]);
        if (notExists) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25" + baseDir, e);
            }
        }
    }
}

