/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.request;

import com.burukeyou.uniapi.http.core.request.HttpBody;
import com.burukeyou.uniapi.http.core.request.MultipartDataItem;
import com.burukeyou.uniapi.http.support.MediaTypeEnum;
import java.io.File;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class HttpBodyMultipart
extends HttpBody {
    private List<MultipartDataItem> multiPartData;

    public HttpBodyMultipart(List<MultipartDataItem> multiPartData) {
        super(MediaTypeEnum.MULTIPART_FORM_DATA.getType());
        this.multiPartData = multiPartData;
    }

    @Override
    public boolean emptyContent() {
        return CollectionUtils.isEmpty(this.multiPartData);
    }

    @Override
    public String toStringBody() {
        if (this.emptyContent()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MultipartDataItem tmp : this.multiPartData) {
            File file = tmp.getFileValue();
            sb.append("\t\t").append(tmp.getKey()).append(":").append(tmp.isFileFlag() && file != null ? file.getAbsolutePath() : tmp.getTextValue()).append("\n");
        }
        return sb.toString();
    }

    public List<MultipartDataItem> getMultiPartData() {
        return this.multiPartData;
    }

    public void setMultiPartData(List<MultipartDataItem> multiPartData) {
        this.multiPartData = multiPartData;
    }
}

