/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.request;

import com.burukeyou.uniapi.http.core.request.HttpBody;
import com.burukeyou.uniapi.http.core.request.HttpUrl;
import com.burukeyou.uniapi.http.support.Cookie;
import com.burukeyou.uniapi.http.support.RequestMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class HttpMetadata {
    private HttpUrl httpUrl = new HttpUrl();
    private RequestMethod requestMethod;
    private HttpBody body;
    private Map<String, String> headers = new HashMap<String, String>();
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public void setUrl(String url) {
        this.httpUrl.setUrl(url);
    }

    public void setUrlPath(String path) {
        this.httpUrl.setPath(path);
    }

    public void putQueryParam(String key, Object value) {
        this.httpUrl.putQueryParam(key, value);
    }

    public void putPathParam(String key, Object value) {
        this.httpUrl.putPathParam(key, value);
    }

    public void putHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void putAllQueryParam(Map<String, Object> queryParam) {
        this.httpUrl.getQueryParam().putAll(queryParam);
    }

    public void putAllPathParam(Map<String, String> pathParam) {
        this.httpUrl.getPathParam().putAll(pathParam);
    }

    public void setBodyIfAbsent(HttpBody httpBody) {
        if (httpBody == null) {
            return;
        }
        if (this.body == null) {
            this.body = httpBody;
        }
    }

    public void putAllHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addAllCookies(List<Cookie> cookiesList) {
        this.cookies.addAll(cookiesList);
    }

    public String getCookieString() {
        return this.cookies.stream().map(e -> e.getName() + "=" + e.getValue()).collect(Collectors.joining(";"));
    }

    public String toHttpProtocol() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n------------------------------------------------");
        sb.append("\n").append(this.requestMethod == null ? "" : this.requestMethod.name()).append("\t\t").append(this.httpUrl.toUrl()).append("\n");
        sb.append("Request Header:\n");
        if (this.body != null) {
            sb.append("\t\tContent-Type:\t\t").append(this.body.getContentType()).append("\n");
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append("\t\t").append(entry.getKey()).append(":\t").append(entry.getValue()).append("\n");
        }
        if (!CollectionUtils.isEmpty(this.cookies)) {
            sb.append("\t\t").append("Cookie:\t").append(this.getCookieString()).append("\n");
        }
        sb.append("Request Body:\n");
        if (this.body != null) {
            sb.append("\t\t").append(this.body.toStringBody()).append("\n");
        }
        sb.append("------------------------------------------------\n");
        return sb.toString();
    }

    public static HttpMetadataBuilder builder() {
        return new HttpMetadataBuilder();
    }

    public HttpUrl getHttpUrl() {
        return this.httpUrl;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public HttpBody getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setHttpUrl(HttpUrl httpUrl) {
        this.httpUrl = httpUrl;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setBody(HttpBody body) {
        this.body = body;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMetadata)) {
            return false;
        }
        HttpMetadata other = (HttpMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpUrl this$httpUrl = this.getHttpUrl();
        HttpUrl other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !((Object)this$httpUrl).equals(other$httpUrl)) {
            return false;
        }
        RequestMethod this$requestMethod = this.getRequestMethod();
        RequestMethod other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !((Object)((Object)this$requestMethod)).equals((Object)other$requestMethod)) {
            return false;
        }
        HttpBody this$body = this.getBody();
        HttpBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<Cookie> this$cookies = this.getCookies();
        List<Cookie> other$cookies = other.getCookies();
        return !(this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpUrl $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : ((Object)$httpUrl).hashCode());
        RequestMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : ((Object)((Object)$requestMethod)).hashCode());
        HttpBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<Cookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        return result;
    }

    public String toString() {
        return "HttpMetadata(httpUrl=" + this.getHttpUrl() + ", requestMethod=" + (Object)((Object)this.getRequestMethod()) + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ", cookies=" + this.getCookies() + ")";
    }

    public HttpMetadata() {
    }

    public HttpMetadata(HttpUrl httpUrl, RequestMethod requestMethod, HttpBody body, Map<String, String> headers, List<Cookie> cookies) {
        this.httpUrl = httpUrl;
        this.requestMethod = requestMethod;
        this.body = body;
        this.headers = headers;
        this.cookies = cookies;
    }

    public static class HttpMetadataBuilder {
        private HttpUrl httpUrl;
        private RequestMethod requestMethod;
        private HttpBody body;
        private Map<String, String> headers;
        private List<Cookie> cookies;

        HttpMetadataBuilder() {
        }

        public HttpMetadataBuilder httpUrl(HttpUrl httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        public HttpMetadataBuilder requestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public HttpMetadataBuilder body(HttpBody body) {
            this.body = body;
            return this;
        }

        public HttpMetadataBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpMetadataBuilder cookies(List<Cookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public HttpMetadata build() {
            return new HttpMetadata(this.httpUrl, this.requestMethod, this.body, this.headers, this.cookies);
        }

        public String toString() {
            return "HttpMetadata.HttpMetadataBuilder(httpUrl=" + this.httpUrl + ", requestMethod=" + (Object)((Object)this.requestMethod) + ", body=" + this.body + ", headers=" + this.headers + ", cookies=" + this.cookies + ")";
        }
    }
}

