/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpUrl
implements Serializable {
    private static final long serialVersionUID = 2542439550827242518L;
    private static Pattern PATH_REGREX = Pattern.compile("\\{\\w+\\}");
    private String url = "";
    private String path = "";
    private String anchor = "";
    private Map<String, Object> queryParam = new HashMap<String, Object>();
    private Map<String, String> pathParam = new HashMap<String, String>();

    public HttpUrl() {
        this.queryParam = new HashMap<String, Object>();
        this.pathParam = new HashMap<String, String>();
    }

    public String toUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.url).append(this.fillPath());
        if (this.queryParam != null && !this.queryParam.isEmpty()) {
            String urlParam = this.queryParam.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).reduce((a, b) -> a + "&" + b).orElse("");
            sb.append("?").append(urlParam);
        }
        return sb.toString();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void putQueryParam(String key, Object value) {
        this.queryParam.put(key, value);
    }

    public void putIfAbsentQueryParam(String key, Object value) {
        this.queryParam.putIfAbsent(key, value);
    }

    public void putPathParam(String key, Object value) {
        this.pathParam.put(key, value == null ? "null" : value.toString());
    }

    public void putIfAbsentPathParam(String key, Object value) {
        this.pathParam.putIfAbsent(key, value == null ? "null" : value.toString());
    }

    public Map<String, Object> getQueryParam() {
        if (this.queryParam == null) {
            this.queryParam = new HashMap<String, Object>();
        }
        return this.queryParam;
    }

    public Map<String, String> getPathParam() {
        if (this.pathParam == null) {
            this.pathParam = new HashMap<String, String>();
        }
        return this.pathParam;
    }

    private String fillPath() {
        Matcher matcher = PATH_REGREX.matcher(this.path);
        StringBuffer pathSB = new StringBuffer();
        String path = this.path.trim();
        boolean exist = matcher.find();
        if (!exist) {
            return path;
        }
        do {
            String group = matcher.group();
            group = group.replace("{", "").replace("}", "");
            String groupData = this.pathParam.get(group);
            matcher.appendReplacement(pathSB, String.valueOf(groupData));
        } while (matcher.find());
        matcher.appendTail(pathSB);
        path = pathSB.toString();
        return path;
    }

    protected HttpUrl(HttpUrlBuilder<?, ?> b) {
        this.url = ((HttpUrlBuilder)b).url;
        this.path = ((HttpUrlBuilder)b).path;
        this.anchor = ((HttpUrlBuilder)b).anchor;
        this.queryParam = ((HttpUrlBuilder)b).queryParam;
        this.pathParam = ((HttpUrlBuilder)b).pathParam;
    }

    public static HttpUrlBuilder<?, ?> builder() {
        return new HttpUrlBuilderImpl();
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public void setQueryParam(Map<String, Object> queryParam) {
        this.queryParam = queryParam;
    }

    public void setPathParam(Map<String, String> pathParam) {
        this.pathParam = pathParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpUrl)) {
            return false;
        }
        HttpUrl other = (HttpUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$anchor = this.getAnchor();
        String other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        Map<String, Object> this$queryParam = this.getQueryParam();
        Map<String, Object> other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !((Object)this$queryParam).equals(other$queryParam)) {
            return false;
        }
        Map<String, String> this$pathParam = this.getPathParam();
        Map<String, String> other$pathParam = other.getPathParam();
        return !(this$pathParam == null ? other$pathParam != null : !((Object)this$pathParam).equals(other$pathParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpUrl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        Map<String, Object> $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : ((Object)$queryParam).hashCode());
        Map<String, String> $pathParam = this.getPathParam();
        result = result * 59 + ($pathParam == null ? 43 : ((Object)$pathParam).hashCode());
        return result;
    }

    public String toString() {
        return "HttpUrl(url=" + this.getUrl() + ", path=" + this.getPath() + ", anchor=" + this.getAnchor() + ", queryParam=" + this.getQueryParam() + ", pathParam=" + this.getPathParam() + ")";
    }

    public HttpUrl(String url, String path, String anchor, Map<String, Object> queryParam, Map<String, String> pathParam) {
        this.url = url;
        this.path = path;
        this.anchor = anchor;
        this.queryParam = queryParam;
        this.pathParam = pathParam;
    }

    private static final class HttpUrlBuilderImpl
    extends HttpUrlBuilder<HttpUrl, HttpUrlBuilderImpl> {
        private HttpUrlBuilderImpl() {
        }

        @Override
        protected HttpUrlBuilderImpl self() {
            return this;
        }

        @Override
        public HttpUrl build() {
            return new HttpUrl(this);
        }
    }

    public static abstract class HttpUrlBuilder<C extends HttpUrl, B extends HttpUrlBuilder<C, B>> {
        private String url;
        private String path;
        private String anchor;
        private Map<String, Object> queryParam;
        private Map<String, String> pathParam;

        public B url(String url) {
            this.url = url;
            return this.self();
        }

        public B path(String path) {
            this.path = path;
            return this.self();
        }

        public B anchor(String anchor) {
            this.anchor = anchor;
            return this.self();
        }

        public B queryParam(Map<String, Object> queryParam) {
            this.queryParam = queryParam;
            return this.self();
        }

        public B pathParam(Map<String, String> pathParam) {
            this.pathParam = pathParam;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "HttpUrl.HttpUrlBuilder(url=" + this.url + ", path=" + this.path + ", anchor=" + this.anchor + ", queryParam=" + this.queryParam + ", pathParam=" + this.pathParam + ")";
        }

        HttpUrlBuilder() {
        }
    }
}

