/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.core.response;

import com.burukeyou.uniapi.http.core.request.HttpBody;
import com.burukeyou.uniapi.http.core.request.HttpMetadata;
import com.burukeyou.uniapi.http.core.response.HttpResponse;
import com.burukeyou.uniapi.http.support.Cookie;
import com.burukeyou.uniapi.http.support.RequestMethod;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractHttpResponse<T>
implements HttpResponse<T> {
    protected transient HttpMetadata httpMetadata;
    private transient Request request;
    protected transient Response response;
    protected transient Method method;
    protected T bodyResult;
    protected Type bodyResultType;

    @Override
    public T getBodyResult() {
        return this.bodyResult;
    }

    public Type getBodyResultType() {
        if (this.bodyResultType == null) {
            if (HttpResponse.class.isAssignableFrom(this.method.getReturnType())) {
                Type genericReturnType = this.method.getGenericReturnType();
                if (genericReturnType instanceof ParameterizedType) {
                    Type actualTypeArgument;
                    this.bodyResultType = actualTypeArgument = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                }
            } else {
                this.bodyResultType = this.method.getGenericReturnType();
            }
        }
        return this.bodyResultType;
    }

    protected boolean ifReturnOriginalResponse() {
        return HttpResponse.class.isAssignableFrom(this.method.getReturnType());
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        Headers headers = this.response.headers();
        for (String name : this.response.headers().names()) {
            map.put(name, headers.get(name));
        }
        return map;
    }

    @Override
    public String getHeader(String name) {
        return this.response.header(name);
    }

    @Override
    public List<String> getHeaderList(String name) {
        return this.response.headers(name);
    }

    @Override
    public int getHttpCode() {
        return this.response.code();
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public List<String> getSetCookiesString() {
        return this.getHeaderList("Set-Cookie");
    }

    @Override
    public List<Cookie> getSetCookies() {
        return AbstractHttpResponse.parseAll(this.request.url(), this.response.headers());
    }

    public static List<Cookie> parseAll(HttpUrl url, Headers headers) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        List cookies = okhttp3.Cookie.parseAll((HttpUrl)url, (Headers)headers);
        for (okhttp3.Cookie tmp : cookies) {
            Cookie cookie = new Cookie();
            BeanUtils.copyProperties((Object)tmp, (Object)cookie);
            cookieList.add(cookie);
        }
        return cookieList;
    }

    public abstract String bodyResultString();

    @Override
    public String toHttpProtocol() {
        RequestMethod requestMethod = this.httpMetadata.getRequestMethod();
        com.burukeyou.uniapi.http.core.request.HttpUrl httpUrl = this.httpMetadata.getHttpUrl();
        HttpBody body = this.httpMetadata.getBody();
        Map<String, String> headers = this.httpMetadata.getHeaders();
        StringBuilder sb = new StringBuilder();
        sb.append("\n------------------------------------------------");
        sb.append("\n").append(requestMethod == null ? "" : requestMethod.name()).append("\t\t").append(httpUrl.toUrl()).append("\n");
        sb.append("Request Header:\n");
        if (body != null) {
            sb.append("\t\tContent-Type:\t\t").append(body.getContentType()).append("\n");
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            sb.append("\t\t").append(entry.getKey()).append(":\t").append(entry.getValue()).append("\n");
        }
        if (!CollectionUtils.isEmpty(this.httpMetadata.getCookies())) {
            sb.append("\t\t").append("Cookie:\t").append(this.httpMetadata.getCookieString()).append("\n");
        }
        sb.append("Request Body:\n");
        if (body != null) {
            sb.append("\t\t").append(body.toStringBody()).append("\n");
        }
        sb.append("Response Header:\n");
        Map stringListMap = this.response.headers().toMultimap();
        stringListMap.forEach((key, value) -> {
            for (String s : value) {
                sb.append("\t\t").append((String)key).append(":\t").append(s).append("\n");
            }
        });
        sb.append("Response Body:\n");
        T result = this.getBodyResult();
        if (result != null) {
            sb.append("\t\t").append(this.bodyResultString()).append("\n");
        }
        sb.append("------------------------------------------------\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        String cookieHeader = "xxx_sso_sessionid=fsadf; Domain=\"\"; Path=/; HttpOnly; name=jay";
        List<HttpCookie> cookies = HttpCookie.parse(cookieHeader);
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        for (HttpCookie cookie : cookies) {
            cookieMap.put(cookie.getName(), cookie.getValue());
        }
        System.out.println();
    }

    public void setHttpMetadata(HttpMetadata httpMetadata) {
        this.httpMetadata = httpMetadata;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setBodyResult(T bodyResult) {
        this.bodyResult = bodyResult;
    }

    public void setBodyResultType(Type bodyResultType) {
        this.bodyResultType = bodyResultType;
    }

    public HttpMetadata getHttpMetadata() {
        return this.httpMetadata;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Method getMethod() {
        return this.method;
    }
}

