/*
 * Decompiled with CFR 0.152.
 */
package com.burukeyou.uniapi.http.support;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum MediaTypeEnum {
    APPLICATION_JSON("application/json"),
    APPLICATION_OCTET_STREAM("application/octet-stream"),
    APPLICATION_FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART_FORM_DATA("multipart/form-data");

    private final String type;

    private MediaTypeEnum(String mediaType) {
        this.type = mediaType;
    }

    public String getType() {
        return this.type;
    }

    public String getChartSetType() {
        return this.type + ";charset=utf-8";
    }

    public boolean equalsMediaType(String mediaType) {
        if (StringUtils.isBlank((CharSequence)mediaType)) {
            return false;
        }
        return mediaType.contains(this.type);
    }

    public static boolean isFileDownLoadType(String mediaType) {
        if (StringUtils.isBlank((CharSequence)mediaType)) {
            return false;
        }
        String[] arr = new String[]{APPLICATION_OCTET_STREAM.getType(), "application/x-download", "application/pdf", "application/zip", "application/x-rar-compressed", "image/jpeg", "image/png"};
        return Arrays.stream(arr).anyMatch(mediaType::contains);
    }
}

