/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.future;

import io.github.jklingsporn.vertx.jooq.future.util.FutureTool;
import io.vertx.core.Vertx;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DAO;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.TableField;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public interface VertxDAO<R extends UpdatableRecord<R>, P, T>
extends DAO<R, P, T> {
    public Vertx vertx();

    public void setVertx(Vertx var1);

    default public <X> CompletableFuture<X> executeAsync(Function<DSLContext, X> function) {
        return FutureTool.executeBlocking(h -> h.complete(function.apply(DSL.using((Configuration)this.configuration()))), this.vertx());
    }

    default public CompletableFuture<Void> insertAsync(P object) {
        return FutureTool.executeBlocking(h -> {
            this.insert(object);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> insertAsync(Collection<P> objects) {
        return FutureTool.executeBlocking(h -> {
            this.insert(objects);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> updateAsync(P object) {
        return FutureTool.executeBlocking(h -> {
            this.update(object);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> updateAsync(Collection<P> objects) {
        return FutureTool.executeBlocking(h -> {
            this.update(objects);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> deleteAsync(Collection<P> objects) {
        return FutureTool.executeBlocking(h -> {
            this.delete(objects);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> deleteByIdAsync(T id) {
        return FutureTool.executeBlocking(h -> {
            this.deleteById(new Object[]{id});
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Void> deleteByIdAsync(Collection<T> ids) {
        return FutureTool.executeBlocking(h -> {
            this.deleteById(ids);
            h.complete();
        }, this.vertx());
    }

    default public CompletableFuture<Boolean> existsAsync(P object) {
        return FutureTool.executeBlocking(h -> h.complete((Object)this.exists(object)), this.vertx());
    }

    default public CompletableFuture<Boolean> existsByIdAsync(T id) {
        return FutureTool.executeBlocking(h -> h.complete((Object)this.existsById(id)), this.vertx());
    }

    default public CompletableFuture<Long> countAsync() {
        return FutureTool.executeBlocking(h -> h.complete((Object)this.count()), this.vertx());
    }

    default public CompletableFuture<List<P>> findAllAsync() {
        return FutureTool.executeBlocking(h -> h.complete((Object)this.findAll()), this.vertx());
    }

    default public CompletableFuture<P> findByIdAsync(T id) {
        return FutureTool.executeBlocking(h -> h.complete(this.findById(id)), this.vertx());
    }

    default public <Z> CompletableFuture<P> fetchOneAsync(Field<Z> field, Z value) {
        return this.fetchOneAsync(field.eq(value));
    }

    default public <Z> CompletableFuture<P> fetchOneAsync(Condition condition) {
        return this.executeAsync(dslContext -> dslContext.selectFrom(this.getTable()).where(new Condition[]{condition}).fetchOne(this.mapper()));
    }

    default public <Z> CompletableFuture<Optional<P>> fetchOptionalAsync(Field<Z> field, Z value) {
        return FutureTool.executeBlocking(h -> h.complete((Object)this.fetchOptional(field, value)), this.vertx());
    }

    default public <Z> CompletableFuture<List<P>> fetchAsync(Field<Z> field, Collection<Z> values) {
        return this.fetchAsync(field.in(values));
    }

    default public CompletableFuture<List<P>> fetchAsync(Condition condition) {
        return this.executeAsync(dslContext -> dslContext.selectFrom(this.getTable()).where(new Condition[]{condition}).fetch(this.mapper()));
    }

    default public CompletableFuture<Integer> deleteExecAsync(T id) {
        UniqueKey uk = this.getTable().getPrimaryKey();
        Objects.requireNonNull(uk, () -> "No primary key");
        TableField[] pk = uk.getFieldsArray();
        Condition condition = pk.length == 1 ? pk[0].equal(pk[0].getDataType().convert(id)) : DSL.row((Field[])pk).equal((Record)id);
        return this.executeAsync(dslContext -> dslContext.deleteFrom(this.getTable()).where(new Condition[]{condition}).execute());
    }

    default public <Z> CompletableFuture<Integer> deleteExecAsync(Condition condition) {
        return this.executeAsync(dslContext -> dslContext.deleteFrom(this.getTable()).where(new Condition[]{condition}).execute());
    }

    default public <Z> CompletableFuture<Integer> deleteExecAsync(Field<Z> field, Z value) {
        return this.deleteExecAsync(field.eq(value));
    }

    default public CompletableFuture<Integer> updateExecAsync(P object) {
        return this.executeAsync(dslContext -> dslContext.executeUpdate((UpdatableRecord)dslContext.newRecord(this.getTable(), object)));
    }

    default public CompletableFuture<Integer> insertExecAsync(P object) {
        return this.executeAsync(dslContext -> dslContext.executeInsert((TableRecord)dslContext.newRecord(this.getTable(), object)));
    }

    default public CompletableFuture<T> insertReturningPrimaryAsync(P object) {
        UniqueKey key = this.getTable().getPrimaryKey();
        Objects.requireNonNull(key, () -> "No primary key");
        return this.executeAsync(dslContext -> {
            UpdatableRecord record = (UpdatableRecord)dslContext.insertInto(this.getTable()).set(dslContext.newRecord(this.getTable(), object)).returning((Collection)key.getFields()).fetchOne();
            Objects.requireNonNull(record, () -> "Failed inserting record or no key");
            Record key1 = record.key();
            if (key1.size() == 1) {
                return ((Record1)key1).value1();
            }
            return key1;
        });
    }
}

