/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.future.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import me.escoffier.vertx.completablefuture.VertxCompletableFuture;

public class FutureTool {
    private FutureTool() {
    }

    public static <T> CompletableFuture<T> executeBlocking(Handler<Future<T>> blockingCodeHandler, Vertx vertx) {
        VertxCompletableFuture future = new VertxCompletableFuture(vertx);
        vertx.executeBlocking(blockingCodeHandler, FutureTool.createCompletionHandler(future));
        return future;
    }

    private static <T> Handler<AsyncResult<T>> createCompletionHandler(VertxCompletableFuture<T> future) {
        return h -> {
            if (h.succeeded()) {
                future.complete(h.result());
            } else {
                future.completeExceptionally(h.cause());
            }
        };
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable e, Vertx vertx) {
        VertxCompletableFuture future = new VertxCompletableFuture(vertx);
        future.completeExceptionally(e);
        return future;
    }
}

