/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate;

import io.github.jklingsporn.vertx.jooq.generate.VertxGeneratorStrategy;
import io.github.jklingsporn.vertx.jooq.generate.VertxJavaWriter;
import io.github.jklingsporn.vertx.jooq.shared.JsonArrayConverter;
import io.github.jklingsporn.vertx.jooq.shared.JsonObjectConverter;
import java.io.File;
import java.time.Instant;
import java.util.List;
import org.jooq.Record;
import org.jooq.tools.JooqLogger;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.JavaGenerator;
import org.jooq.util.JavaWriter;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;

public abstract class AbstractVertxGenerator
extends JavaGenerator {
    private static final JooqLogger logger = JooqLogger.getLogger(AbstractVertxGenerator.class);
    private final boolean generateJson;
    private VertxGeneratorStrategy unwrappedStrategy;

    public AbstractVertxGenerator() {
        this(true);
    }

    public AbstractVertxGenerator(boolean generateJson) {
        this.generateJson = generateJson;
        this.setGeneratePojos(true);
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
        super.generateDaoClassFooter(table, out);
        this.generateFetchMethods(table, out);
        this.generateVertxGetterAndSetterConfigurationMethod(out);
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
        super.generatePojoClassFooter(table, out);
        if (this.generateJson) {
            this.generateFromJsonConstructor(table, out);
            if (!this.generateInterfaces()) {
                this.generateFromJson(table, out);
                this.generateToJson(table, out);
            }
        }
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
        super.generateInterfaceClassFooter(table, out);
        if (this.generateJson && this.generateInterfaces()) {
            this.generateFromJson(table, out);
            this.generateToJson(table, out);
        }
    }

    protected void generateDao(TableDefinition table, JavaWriter out) {
        if (table.getPrimaryKey() != null) {
            ((VertxJavaWriter)out).setDaoTypeReplacement(this.getKeyType(table.getPrimaryKey()));
        }
        super.generateDao(table, out);
    }

    protected JavaWriter newJavaWriter(File file) {
        return new VertxJavaWriter(file, this.generateFullyQualifiedTypes(), this.targetEncoding);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        super.printPackage(out, definition, mode);
        if (mode.equals((Object)GeneratorStrategy.Mode.DAO)) {
            this.generateDAOImports(out);
        }
    }

    protected abstract void generateDAOImports(JavaWriter var1);

    protected void generateSetVertxAnnotation(JavaWriter out) {
    }

    protected void generateVertxGetterAndSetterConfigurationMethod(JavaWriter out) {
        out.println();
        ((JavaWriter)out.tab(1)).println("private io.vertx.core.Vertx vertx;");
        out.println();
        this.generateSetVertxAnnotation(out);
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("public void setVertx(io.vertx.core.Vertx vertx) {");
        ((JavaWriter)out.tab(2)).println("this.vertx = vertx;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("public io.vertx.core.Vertx vertx() {");
        ((JavaWriter)out.tab(2)).println("return this.vertx;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    private void generateFromJson(TableDefinition table, JavaWriter out) {
        out.println();
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
        ((JavaWriter)out.tab(1)).println("default %s fromJson(io.vertx.core.json.JsonObject json) {", new Object[]{className});
        for (TypedElementDefinition column : table.getColumns()) {
            String javaMemberName;
            String columnType;
            String setter;
            if (this.handleCustomTypeFromJson(column, setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE), columnType = this.getJavaType(column.getType()), javaMemberName = this.getJsonKeyName(column), out)) continue;
            if (this.isType(columnType, Integer.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getInteger(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Short.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getInteger(\"%s\")==null?null:json.getInteger(\"%s\").shortValue());", new Object[]{setter, javaMemberName, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Byte.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getInteger(\"%s\")==null?null:json.getInteger(\"%s\").byteValue());", new Object[]{setter, javaMemberName, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Long.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getLong(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Float.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getFloat(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Double.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getDouble(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Boolean.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getBoolean(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, String.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getString(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (columnType.equals(Byte.TYPE.getName() + "[]")) {
                ((JavaWriter)out.tab(2)).println("%s(json.getBinary(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isType(columnType, Instant.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getInstant(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (this.isEnum(table, column)) {
                ((JavaWriter)out.tab(2)).println("%s(java.util.Arrays.stream(%s.values()).filter(td -> td.getLiteral().equals(json.getString(\"%s\"))).findFirst().orElse(null));", new Object[]{setter, columnType, javaMemberName});
                continue;
            }
            if (column.getType().getConverter() != null && this.isType(column.getType().getConverter(), JsonObjectConverter.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getJsonObject(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            if (column.getType().getConverter() != null && this.isType(column.getType().getConverter(), JsonArrayConverter.class)) {
                ((JavaWriter)out.tab(2)).println("%s(json.getJsonArray(\"%s\"));", new Object[]{setter, javaMemberName});
                continue;
            }
            logger.warn((Object)String.format("Omitting unrecognized type %s for column %s in table %s!", columnType, column.getName(), table.getName()));
            ((JavaWriter)out.tab(2)).println(String.format("// Omitting unrecognized type %s for column %s!", columnType, column.getName()));
        }
        ((JavaWriter)out.tab(2)).println("return this;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    private boolean isEnum(TableDefinition table, TypedElementDefinition<?> column) {
        return table.getDatabase().getEnum(table.getSchema(), column.getType().getUserType()) != null;
    }

    private boolean isType(String columnType, Class<?> clazz) {
        return columnType.equals(clazz.getName());
    }

    protected boolean handleCustomTypeFromJson(TypedElementDefinition<?> column, String setter, String columnType, String javaMemberName, JavaWriter out) {
        return false;
    }

    private void generateToJson(TableDefinition table, JavaWriter out) {
        out.println();
        ((JavaWriter)out.tab(1)).println("default io.vertx.core.json.JsonObject toJson() {");
        ((JavaWriter)out.tab(2)).println("io.vertx.core.json.JsonObject json = new io.vertx.core.json.JsonObject();");
        for (TypedElementDefinition column : table.getColumns()) {
            String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
            String columnType = this.getJavaType(column.getType());
            if (this.handleCustomTypeToJson(column, getter, this.getJavaType(column.getType()), this.getJsonKeyName(column), out)) continue;
            if (this.isEnum(table, column)) {
                ((JavaWriter)out.tab(2)).println("json.put(\"%s\",%s()==null?null:%s().getLiteral());", new Object[]{this.getJsonKeyName(column), getter, getter});
                continue;
            }
            if (this.isAllowedJsonType(column, columnType)) {
                ((JavaWriter)out.tab(2)).println("json.put(\"%s\",%s());", new Object[]{this.getJsonKeyName(column), getter});
                continue;
            }
            logger.warn((Object)String.format("Omitting unrecognized type %s for column %s in table %s!", columnType, column.getName(), table.getName()));
            ((JavaWriter)out.tab(2)).println(String.format("// Omitting unrecognized type %s for column %s!", columnType, column.getName()));
        }
        ((JavaWriter)out.tab(2)).println("return json;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    protected String getJsonKeyName(TypedElementDefinition<?> column) {
        return this.getUnwrappedStrategy().getJsonKeyName(column);
    }

    private boolean isAllowedJsonType(TypedElementDefinition<?> column, String columnType) {
        return this.isType(columnType, Integer.class) || this.isType(columnType, Short.class) || this.isType(columnType, Byte.class) || this.isType(columnType, Long.class) || this.isType(columnType, Float.class) || this.isType(columnType, Double.class) || this.isType(columnType, Boolean.class) || this.isType(columnType, String.class) || this.isType(columnType, Instant.class) || columnType.equals(Byte.TYPE.getName() + "[]") || column.getType().getConverter() != null && (this.isType(column.getType().getConverter(), JsonObjectConverter.class) || this.isType(column.getType().getConverter(), JsonArrayConverter.class));
    }

    public void setStrategy(GeneratorStrategy strategy) {
        if (!(strategy instanceof VertxGeneratorStrategy)) {
            throw new IllegalArgumentException(String.format("%s is not an instance of %s", strategy.getClass().getName(), VertxGeneratorStrategy.class.getName()));
        }
        this.unwrappedStrategy = (VertxGeneratorStrategy)strategy;
        super.setStrategy(strategy);
    }

    public VertxGeneratorStrategy getUnwrappedStrategy() {
        return this.unwrappedStrategy;
    }

    protected boolean handleCustomTypeToJson(TypedElementDefinition<?> column, String getter, String columnType, String javaMemberName, JavaWriter out) {
        return false;
    }

    private void generateFromJsonConstructor(TableDefinition table, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
        out.println();
        ((JavaWriter)out.tab(1)).println("public %s(io.vertx.core.json.JsonObject json) {", new Object[]{className});
        ((JavaWriter)out.tab(2)).println("fromJson(json);");
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void generateFetchMethods(TableDefinition table, JavaWriter out) {
        VertxJavaWriter vOut = (VertxJavaWriter)out;
        String pType = vOut.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        block0: for (ColumnDefinition column : table.getColumns()) {
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column);
            String colType = vOut.ref(this.getJavaType(column.getType()));
            String colIdentifier = vOut.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            this.generateFetchByMethods(out, pType, colName, colClass, colType, colIdentifier);
            for (UniqueKeyDefinition uk : column.getUniqueKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column)) continue;
                this.generateFetchOneByMethods(out, pType, colName, colClass, colType);
                continue block0;
            }
        }
    }

    protected abstract void generateFetchOneByMethods(JavaWriter var1, String var2, String var3, String var4, String var5);

    protected abstract void generateFetchByMethods(JavaWriter var1, String var2, String var3, String var4, String var5, String var6);

    protected String getKeyType(UniqueKeyDefinition key) {
        String tType;
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType());
        } else if (keyColumns.size() <= 22) {
            String generics = "";
            String separator = "";
            for (ColumnDefinition column : keyColumns) {
                generics = generics + separator + this.getJavaType(column.getType());
                separator = ", ";
            }
            tType = Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        return tType;
    }

    private int colRefSegments(TypedElementDefinition<?> column) {
        if (column != null && column.getContainer() instanceof UDTDefinition) {
            return 2;
        }
        if (!this.getStrategy().getInstanceFields()) {
            return 2;
        }
        return 3;
    }
}

