/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate;

import io.github.jklingsporn.vertx.jooq.generate.AbstractVertxGenerator;
import java.io.File;
import org.jooq.tools.JooqLogger;
import org.jooq.util.Definition;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.JavaWriter;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public abstract class AbstractVertxGuiceGenerator
extends AbstractVertxGenerator {
    private static final JooqLogger logger = JooqLogger.getLogger(AbstractVertxGuiceGenerator.class);
    private final String daoClassName;
    private final boolean generateGuiceModules;
    private final boolean generateInjectAnnotations;

    public AbstractVertxGuiceGenerator(String daoClassName) {
        this(daoClassName, true, true, true);
    }

    public AbstractVertxGuiceGenerator(String daoClassName, boolean generateJson, boolean generateGuiceModules, boolean generateInjectConfigurationMethod) {
        super(generateJson);
        this.daoClassName = daoClassName;
        this.generateGuiceModules = generateGuiceModules;
        this.generateInjectAnnotations = generateInjectConfigurationMethod;
    }

    @Override
    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
        super.generateDaoClassFooter(table, out);
        if (this.generateInjectAnnotations) {
            this.generateSetConfigurationMethod(out);
        }
    }

    @Override
    protected void generateSetVertxAnnotation(JavaWriter out) {
        ((JavaWriter)out.tab(1)).println("@javax.inject.Inject");
    }

    protected void generateDaos(SchemaDefinition schema) {
        super.generateDaos(schema);
        if (this.generateGuiceModules) {
            this.generateDAOModule(schema);
        }
    }

    private void generateSetConfigurationMethod(JavaWriter out) {
        out.println();
        ((JavaWriter)out.tab(1)).println("@javax.inject.Inject");
        this.generateSetConfigurationAnnotation(out);
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("public void setConfiguration(Configuration configuration) {");
        ((JavaWriter)out.tab(2)).println("super.setConfiguration(configuration);");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    protected void generateSetConfigurationAnnotation(JavaWriter out) {
    }

    protected void generateDAOModule(SchemaDefinition schema) {
        logger.info((Object)"Generate DaoModule ... ");
        JavaWriter out = this.newJavaWriter(this.getModuleFile(schema));
        out.println("package " + this.getStrategy().getJavaPackageName((Definition)schema) + ".tables.modules;");
        out.println();
        out.println("import com.google.inject.AbstractModule;");
        out.println("import com.google.inject.TypeLiteral;");
        out.println("import %s;", new Object[]{this.daoClassName});
        out.println();
        out.println("public class DaoModule extends AbstractModule {");
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("protected void configure() {");
        for (TableDefinition definition : schema.getTables()) {
            this.generateDAOBinding(definition, out);
        }
        ((JavaWriter)out.tab(1)).println("}");
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generateDAOBinding(TableDefinition table, JavaWriter out) {
        UniqueKeyDefinition key = table.getPrimaryKey();
        if (key == null) {
            logger.info((Object)"{} has no primary key. Skipping...", (Object)out.file().getName());
            return;
        }
        String keyType = this.getKeyType(key);
        String tableRecord = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
        String pType = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
        String className = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        if (this.generateInterfaces()) {
            String iType = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
            ((JavaWriter)out.tab(2)).println("bind(new TypeLiteral<VertxDAO<%s, ? extends %s, %s>>() {}).to(%s.class).asEagerSingleton();", new Object[]{tableRecord, iType, keyType, className});
        }
        ((JavaWriter)out.tab(2)).println("bind(new TypeLiteral<VertxDAO<%s, %s, %s>>() {}).to(%s.class).asEagerSingleton();", new Object[]{tableRecord, pType, keyType, className});
    }

    protected File getModuleFile(SchemaDefinition definition) {
        String packageName = (this.getStrategy().getTargetDirectory() + "/" + this.getStrategy().getJavaPackageName((Definition)definition) + ".tables.modules").replaceAll("\\.", "/");
        return new File(packageName, "DaoModule.java");
    }
}

