/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate.future;

import io.github.jklingsporn.vertx.jooq.generate.AbstractVertxGenerator;
import java.util.List;
import org.jooq.util.JavaWriter;

public class FutureVertxGenerator
extends AbstractVertxGenerator {
    public static final String VERTX_DAO_NAME = "io.github.jklingsporn.vertx.jooq.future.VertxDAO";

    @Override
    protected void generateDAOImports(JavaWriter out) {
        out.println("import java.util.concurrent.CompletableFuture;");
        out.println("import io.github.jklingsporn.vertx.jooq.future.util.FutureTool;");
    }

    @Override
    protected void generateFetchOneByMethods(JavaWriter out, String pType, String colName, String colClass, String colType) {
        ((JavaWriter)out.tab(1)).javadoc("Fetch a unique record that has <code>%s = value</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public CompletableFuture<%s> fetchOneBy%sAsync(%s value) {", new Object[]{pType, colClass, colType});
        ((JavaWriter)out.tab(2)).println("return FutureTool.executeBlocking(h->h.complete(fetchOneBy%s(value)),vertx());", new Object[]{colClass});
        ((JavaWriter)out.tab(1)).println("}");
    }

    @Override
    protected void generateFetchByMethods(JavaWriter out, String pType, String colName, String colClass, String colType, String colIdentifier) {
        ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public CompletableFuture<List<%s>> fetchBy%sAsync(%s<%s> values) {", new Object[]{pType, colClass, List.class, colType});
        ((JavaWriter)out.tab(2)).println("return fetchAsync(%s,values);", new Object[]{colIdentifier});
        ((JavaWriter)out.tab(1)).println("}");
    }
}

