/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate.rx;

import io.github.jklingsporn.vertx.jooq.generate.AbstractVertxGenerator;
import java.util.List;
import org.jooq.util.JavaWriter;

public class RXVertxGenerator
extends AbstractVertxGenerator {
    public static final String VERTX_DAO_NAME = "io.github.jklingsporn.vertx.jooq.rx.VertxDAO";

    @Override
    protected void generateDAOImports(JavaWriter out) {
        out.println("import io.reactivex.Completable;");
        out.println("import io.reactivex.Observable;");
        out.println("import io.reactivex.Single;");
        out.println("import io.github.jklingsporn.vertx.jooq.rx.util.RXTool;");
    }

    @Override
    protected void generateFetchOneByMethods(JavaWriter out, String pType, String colName, String colClass, String colType) {
        ((JavaWriter)out.tab(1)).javadoc("Fetch a unique record that has <code>%s = value</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public Single<%s> fetchOneBy%sAsync(%s value) {", new Object[]{pType, colClass, colType});
        ((JavaWriter)out.tab(2)).println("return RXTool.executeBlocking(h->h.complete(fetchOneBy%s(value)),vertx());", new Object[]{colClass});
        ((JavaWriter)out.tab(1)).println("}");
    }

    @Override
    protected void generateFetchByMethods(JavaWriter out, String pType, String colName, String colClass, String colType, String colIdentifier) {
        ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public Single<List<%s>> fetchBy%sAsync(%s<%s> values) {", new Object[]{pType, colClass, List.class, colType});
        ((JavaWriter)out.tab(2)).println("return fetchAsync(%s,values);", new Object[]{colIdentifier});
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public Observable<%s> fetchBy%sObservable(%s<%s> values) {", new Object[]{pType, colClass, List.class, colType});
        ((JavaWriter)out.tab(2)).println("return fetchObservable(%s,values);", new Object[]{colIdentifier});
        ((JavaWriter)out.tab(1)).println("}");
    }

    @Override
    protected void generateVertxGetterAndSetterConfigurationMethod(JavaWriter out) {
        out.println();
        ((JavaWriter)out.tab(1)).println("private io.vertx.reactivex.core.Vertx vertx;");
        out.println();
        this.generateSetVertxAnnotation(out);
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("public void setVertx(io.vertx.reactivex.core.Vertx vertx) {");
        ((JavaWriter)out.tab(2)).println("this.vertx = vertx;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
        ((JavaWriter)out.tab(1)).println("@Override");
        ((JavaWriter)out.tab(1)).println("public io.vertx.reactivex.core.Vertx vertx() {");
        ((JavaWriter)out.tab(2)).println("return this.vertx;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }
}

