/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.mqtt.entity;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;

public class MessageHeader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MessageHeader.class);
    private UUID id;
    private Integer mqttId;
    private Integer mqttReceivedQos;
    private String mqttReceivedTopic;
    private Boolean mqttDuplicate;
    private Boolean mqttReceivedRetained;
    private Long timestamp;

    public MessageHeader(MessageHeaders messageHeaders) {
        if (Objects.nonNull(messageHeaders)) {
            this.id = messageHeaders.getId();
            this.mqttId = this.getMessageHeader(messageHeaders, "mqtt_id", Integer.class);
            this.mqttReceivedQos = this.getMessageHeader(messageHeaders, "mqtt_receivedQos", Integer.class);
            this.mqttReceivedTopic = this.getMessageHeader(messageHeaders, "mqtt_receivedTopic", String.class);
            this.mqttDuplicate = this.getMessageHeader(messageHeaders, "mqtt_duplicate", Boolean.class);
            this.mqttReceivedRetained = this.getMessageHeader(messageHeaders, "mqtt_receivedRetained", Boolean.class);
            this.timestamp = this.getMessageHeader(messageHeaders, "timestamp", Long.class);
        }
    }

    private <T> T getMessageHeader(MessageHeaders messageHeaders, String key, Class<T> type) {
        try {
            return (T)messageHeaders.get((Object)key, type);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public UUID getId() {
        return this.id;
    }

    public Integer getMqttId() {
        return this.mqttId;
    }

    public Integer getMqttReceivedQos() {
        return this.mqttReceivedQos;
    }

    public String getMqttReceivedTopic() {
        return this.mqttReceivedTopic;
    }

    public Boolean getMqttDuplicate() {
        return this.mqttDuplicate;
    }

    public Boolean getMqttReceivedRetained() {
        return this.mqttReceivedRetained;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setMqttId(Integer mqttId) {
        this.mqttId = mqttId;
    }

    public void setMqttReceivedQos(Integer mqttReceivedQos) {
        this.mqttReceivedQos = mqttReceivedQos;
    }

    public void setMqttReceivedTopic(String mqttReceivedTopic) {
        this.mqttReceivedTopic = mqttReceivedTopic;
    }

    public void setMqttDuplicate(Boolean mqttDuplicate) {
        this.mqttDuplicate = mqttDuplicate;
    }

    public void setMqttReceivedRetained(Boolean mqttReceivedRetained) {
        this.mqttReceivedRetained = mqttReceivedRetained;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

